/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class StateVersionResponse
extends Packet {
    public static final int TYPE = 33;
    public static final Field<Long> FIELD_VENDOR = new UInt32Field().little();
    public static final Field<Long> FIELD_PRODUCT = new UInt32Field().little();
    public static final Field<Long> FIELD_VERSION = new UInt32Field().little();
    private long vendor;
    private long product;
    private long version;

    public long getVendor() {
        return this.vendor;
    }

    public void setVendor(long build) {
        this.vendor = build;
    }

    public long getProduct() {
        return this.product;
    }

    public void setProduct(long product) {
        this.product = product;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public StateVersionResponse() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    @Override
    public int packetType() {
        return 33;
    }

    @Override
    protected int packetLength() {
        return 12;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.vendor = FIELD_VENDOR.value(bytes);
        this.product = FIELD_PRODUCT.value(bytes);
        this.version = FIELD_VERSION.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_VENDOR.bytes(this.vendor)).put(FIELD_PRODUCT.bytes(this.product)).put(FIELD_VERSION.bytes(this.version));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

