/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class LifxThrottlingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifxThrottlingUtil.class);
    private static List<LifxLightCommunicationTracker> trackers = new CopyOnWriteArrayList<LifxLightCommunicationTracker>();
    private static Map<MACAddress, @Nullable LifxLightCommunicationTracker> macTrackerMapping = new ConcurrentHashMap<MACAddress, LifxLightCommunicationTracker>();

    private LifxThrottlingUtil() {
    }

    public static void lock(@Nullable MACAddress mac) {
        if (mac != null) {
            LifxLightCommunicationTracker tracker = LifxThrottlingUtil.getOrCreateTracker(mac);
            tracker.lock();
            LifxThrottlingUtil.waitForNextPacketInterval(tracker.getTimestamp());
        } else {
            LifxThrottlingUtil.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LifxLightCommunicationTracker getOrCreateTracker(MACAddress mac) {
        LifxLightCommunicationTracker tracker = macTrackerMapping.get(mac);
        if (tracker == null) {
            List<LifxLightCommunicationTracker> list = trackers;
            synchronized (list) {
                tracker = macTrackerMapping.get(mac);
                if (tracker == null) {
                    tracker = new LifxLightCommunicationTracker();
                    trackers.add(tracker);
                    macTrackerMapping.put(mac, tracker);
                }
            }
        }
        return tracker;
    }

    private static void waitForNextPacketInterval(long timestamp) {
        long timeToWait = Math.max(50L - (System.currentTimeMillis() - timestamp), 0L);
        if (timeToWait > 0L) {
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException e) {
                LOGGER.error("An exception occurred while putting the thread to sleep : '{}'", (Object)e.getMessage());
            }
        }
    }

    public static void unlock(@Nullable MACAddress mac) {
        if (mac != null) {
            LifxLightCommunicationTracker tracker = macTrackerMapping.get(mac);
            if (tracker != null) {
                tracker.unlock();
            }
        } else {
            LifxThrottlingUtil.unlock();
        }
    }

    public static void lock() {
        long lastStamp = 0L;
        for (LifxLightCommunicationTracker tracker : trackers) {
            tracker.lock();
            lastStamp = Math.max(lastStamp, tracker.getTimestamp());
        }
        LifxThrottlingUtil.waitForNextPacketInterval(lastStamp);
    }

    public static void unlock() {
        for (LifxLightCommunicationTracker tracker : trackers) {
            tracker.unlock();
        }
    }

    private static class LifxLightCommunicationTracker {
        private long timestamp;
        private ReentrantLock lock = new ReentrantLock();

        private LifxLightCommunicationTracker() {
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            if (this.lock.isHeldByCurrentThread()) {
                this.timestamp = System.currentTimeMillis();
                this.lock.unlock();
            }
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

