/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lirc.internal.connector;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.binding.lirc.internal.LIRCResponseException;
import org.eclipse.smarthome.binding.lirc.internal.connector.LIRCConnector;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCButtonEvent;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIRCStreamReader
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(LIRCStreamReader.class);
    private static final Pattern EVENT_PATTERN = Pattern.compile("^([a-f0-9]+)\\s([a-f0-9]+)\\s(.+)\\s(.+)$");
    private InputStream in;
    private boolean interrupted = false;
    private BufferedReader reader;
    private LIRCConnector connector;

    public LIRCStreamReader(LIRCConnector connector, InputStream in) {
        this.connector = connector;
        this.in = in;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        super.interrupt();
    }

    @Override
    public void run() {
        this.reader = new BufferedReader(new InputStreamReader(this.in));
        String responseText = "";
        while (!this.interrupted) {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    throw new EOFException("lost connection");
                }
                this.logger.trace("Received message: {}", (Object)line);
                Matcher m = EVENT_PATTERN.matcher(line);
                if (m.matches()) {
                    String code = m.group(1);
                    String repeatsHex = m.group(2);
                    String button = m.group(3);
                    String remote = m.group(4);
                    int repeats = Integer.parseInt(repeatsHex, 16);
                    LIRCButtonEvent buttonMessage = new LIRCButtonEvent(remote, button, repeats, code);
                    this.connector.sendButtonToListeners(buttonMessage);
                    continue;
                }
                if ("BEGIN".equals(line)) {
                    responseText = "";
                    continue;
                }
                if ("END".equals(line)) {
                    this.processResponse(responseText);
                    responseText = null;
                    continue;
                }
                responseText = String.valueOf(responseText) + line + "\n";
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
                this.logger.error("Interrupted via InterruptedIOException");
            }
            catch (EOFException e) {
                this.logger.error("Lost connection to LIRC server", (Throwable)e);
                this.connector.sendErrorToListeners(e.getMessage());
                this.interrupt();
            }
            catch (IOException e) {
                if (this.interrupted) continue;
                this.logger.error("Reading from socket failed", (Throwable)e);
                this.connector.sendErrorToListeners(e.getMessage());
            }
            catch (LIRCResponseException e) {
                this.logger.error("Invalid message received", (Throwable)e);
            }
        }
        IOUtils.closeQuietly((Reader)this.reader);
    }

    private void processResponse(String responseText) throws LIRCResponseException {
        String[] parts = responseText.split("\n");
        String command = parts[0];
        boolean success = true;
        int dataLength = 0;
        String[] data = null;
        if (parts.length > 1) {
            if ("SUCCESS".equals(parts[1]) || "ERROR".equals(parts[1])) {
                success = "SUCCESS".equals(parts[1]);
            } else {
                throw new LIRCResponseException("Malformed response");
            }
        }
        if (parts.length > 2) {
            if ("DATA".equals(parts[2]) && parts.length > 3) {
                dataLength = Integer.parseInt(parts[3]);
            } else {
                throw new LIRCResponseException("Malformed response");
            }
        }
        if (parts.length > 4 && (data = Arrays.copyOfRange(parts, 4, parts.length)).length != dataLength) {
            throw new LIRCResponseException(String.format("Data does not match expected length. Expected: %s, Got: %s", dataLength, data.length));
        }
        LIRCResponse response = new LIRCResponse(command, success, data);
        this.connector.sendMessageToListeners(response);
    }
}

