/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.meteoblue.internal;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.eclipse.smarthome.binding.meteoblue.internal.json.JsonDataDay;
import org.eclipse.smarthome.binding.meteoblue.internal.json.JsonMetadata;
import org.eclipse.smarthome.binding.meteoblue.internal.json.JsonUnits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Forecast {
    private final Logger logger = LoggerFactory.getLogger(Forecast.class);
    private Double latitude;
    private Double longitude;
    private Integer height;
    private String timeZoneAbbreviation;
    private String timeUnits;
    private String predictabilityUnits;
    private String precipitationProbabilityUnits;
    private String pressureUnits;
    private String relativeHumidityUnits;
    private String temperatureUnits;
    private String windDirectionUnits;
    private String precipitationUnits;
    private String windSpeedUnits;
    private Calendar forecastDate;
    private Integer pictocode;
    private Integer UVIndex;
    private Double minTemperature;
    private Double maxTemperature;
    private Double meanTemperature;
    private Double feltTemperatureMin;
    private Double feltTemperatureMax;
    private Integer windDirection;
    private Integer precipitationProbability;
    private String rainSpot;
    private Integer predictabilityClass;
    private Integer predictability;
    private Double precipitation;
    private Double snowFraction;
    private Integer minSeaLevelPressure;
    private Integer maxSeaLevelPressure;
    private Integer meanSeaLevelPressure;
    private Double minWindSpeed;
    private Double maxWindSpeed;
    private Double meanWindSpeed;
    private Integer relativeHumidityMin;
    private Integer relativeHumidityMax;
    private Integer relativeHumidityMean;
    private Double convectivePrecipitation;
    private Double precipitationHours;
    private Double humidityGreater90Hours;
    private String cardinalWindDirection;
    private String iconName;
    private Image icon;
    private Image rainArea;
    private Double snowFall;

    public Forecast(int whichDay, JsonMetadata metadata, JsonUnits units, JsonDataDay dataDay) throws IllegalArgumentException {
        if (metadata == null) {
            throw new IllegalArgumentException("Received no metadata information.");
        }
        if (dataDay == null) {
            throw new IllegalArgumentException("Received no data_day information.");
        }
        if (whichDay > dataDay.getTime().length - 1) {
            throw new IndexOutOfBoundsException("No data received for day " + whichDay);
        }
        this.latitude = metadata.getLatitude();
        this.longitude = metadata.getLongitude();
        this.height = metadata.getHeight();
        this.timeZoneAbbreviation = metadata.getTimeZoneAbbreviation();
        this.logger.trace("Metadata:");
        this.logger.trace("  Latitude: {}", (Object)this.latitude);
        this.logger.trace("  Longitude: {}", (Object)this.longitude);
        this.logger.trace("  Height: {}", (Object)this.height);
        this.logger.trace("  TZ Abbrev: {}", (Object)this.timeZoneAbbreviation);
        this.timeUnits = units.getTime();
        this.predictabilityUnits = units.getPredictability();
        this.precipitationProbabilityUnits = units.getPrecipitationProbability();
        this.pressureUnits = units.getPressure();
        this.relativeHumidityUnits = units.getRelativeHumidity();
        this.temperatureUnits = units.getTemperature();
        this.windDirectionUnits = units.getWindDirection();
        this.precipitationUnits = units.getPrecipitation();
        this.windSpeedUnits = units.getWindSpeed();
        this.logger.trace("Units:");
        this.logger.trace("  Time: {}", (Object)this.timeUnits);
        this.logger.trace("  Predictability: {}", (Object)this.predictabilityUnits);
        this.logger.trace("  Precipitation Probability: {}", (Object)this.precipitationProbabilityUnits);
        this.logger.trace("  Pressure: {}", (Object)this.pressureUnits);
        this.logger.trace("  Relative Humidity: {}", (Object)this.relativeHumidityUnits);
        this.logger.trace("  Temperature: {}", (Object)this.temperatureUnits);
        this.logger.trace("  Wind Direction: {}", (Object)this.windDirectionUnits);
        this.logger.trace("  Precipitation: {}", (Object)this.precipitationUnits);
        this.logger.trace("  Wind Speed: {}", (Object)this.windSpeedUnits);
        String timeString = dataDay.getTime()[whichDay];
        try {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone(this.timeZoneAbbreviation));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            c.setTime(formatter.parse(timeString));
            this.forecastDate = c;
        }
        catch (ParseException parseException) {
            this.logger.debug("Failed to parse the value '{}' as a date.", (Object)timeString);
        }
        this.pictocode = dataDay.getPictocode()[whichDay];
        this.iconName = this.getIconNameForPictocode(this.pictocode);
        this.icon = this.loadImageIcon(this.iconName);
        this.UVIndex = dataDay.getUVIndex()[whichDay];
        this.maxTemperature = dataDay.getTemperatureMax()[whichDay];
        this.minTemperature = dataDay.getTemperatureMin()[whichDay];
        this.meanTemperature = dataDay.getTemperatureMean()[whichDay];
        this.feltTemperatureMax = dataDay.getFeltTemperatureMax()[whichDay];
        this.feltTemperatureMin = dataDay.getFeltTemperatureMin()[whichDay];
        this.windDirection = dataDay.getWindDirection()[whichDay];
        this.cardinalWindDirection = this.getCardinalDirection(this.windDirection);
        this.precipitationProbability = dataDay.getPrecipitationProbability()[whichDay];
        this.rainSpot = dataDay.getRainspot()[whichDay];
        this.rainArea = this.generateRainAreaImage();
        this.predictabilityClass = dataDay.getPredictabilityClass()[whichDay];
        this.predictability = dataDay.getPredictability()[whichDay];
        this.precipitation = dataDay.getPrecipitation()[whichDay];
        this.snowFraction = dataDay.getSnowFraction()[whichDay];
        this.maxSeaLevelPressure = dataDay.getSeaLevelPressureMax()[whichDay];
        this.minSeaLevelPressure = dataDay.getSeaLevelPressureMin()[whichDay];
        this.meanSeaLevelPressure = dataDay.getSeaLevelPressureMean()[whichDay];
        this.maxWindSpeed = dataDay.getWindSpeedMax()[whichDay];
        this.meanWindSpeed = dataDay.getWindSpeedMean()[whichDay];
        this.minWindSpeed = dataDay.getWindSpeedMin()[whichDay];
        this.relativeHumidityMax = dataDay.getRelativeHumidityMax()[whichDay];
        this.relativeHumidityMin = dataDay.getRelativeHumidityMin()[whichDay];
        this.relativeHumidityMean = dataDay.getRelativeHumidityMean()[whichDay];
        this.convectivePrecipitation = dataDay.getConvectivePrecipitation()[whichDay];
        this.snowFall = this.snowFraction * this.precipitation;
        this.precipitationHours = dataDay.getPrecipitationHours()[whichDay];
        this.humidityGreater90Hours = dataDay.getHumidityGreater90Hours()[whichDay];
        this.logger.trace("DataDay:");
        this.logger.trace("  Time: {}", (Object)this.forecastDate);
        this.logger.trace("  Pictocode: {}", (Object)this.pictocode);
        this.logger.trace("  Icon: {}", (Object)this.icon);
        this.logger.trace("  UV Index: {}", (Object)this.UVIndex);
        this.logger.trace("  Max Temperature: {}", (Object)this.maxTemperature);
        this.logger.trace("  Min Temperature: {}", (Object)this.minTemperature);
        this.logger.trace("  Mean Temperature: {}", (Object)this.meanTemperature);
        this.logger.trace("  Felt Temperature Max: {}", (Object)this.feltTemperatureMax);
        this.logger.trace("  Felt Temperature Min: {}", (Object)this.feltTemperatureMin);
        this.logger.trace("  Wind Direction: {}", (Object)this.windDirection);
        this.logger.trace("  Precipitation Probability: {}", (Object)this.precipitationProbability);
        this.logger.trace("  Rainspot: {}", (Object)this.rainSpot);
        this.logger.trace("  Rain Area: {}", (Object)this.rainArea);
        this.logger.trace("  Predictability Class: {}", (Object)this.predictabilityClass);
        this.logger.trace("  Predictability: {}", (Object)this.predictability);
        this.logger.trace("  Precipitation: {}", (Object)this.precipitation);
        this.logger.trace("  Snow Fraction: {}", (Object)this.snowFraction);
        this.logger.trace("  Max Sea-level Pressure: {}", (Object)this.maxSeaLevelPressure);
        this.logger.trace("  Min Sea-level Pressure: {}", (Object)this.minSeaLevelPressure);
        this.logger.trace("  Mean Sea-level Pressure: {}", (Object)this.meanSeaLevelPressure);
        this.logger.trace("  Max Wind Speed: {}", (Object)this.maxWindSpeed);
        this.logger.trace("  Mean Wind Speed: {}", (Object)this.meanWindSpeed);
        this.logger.trace("  Min Wind Speed: {}", (Object)this.minWindSpeed);
        this.logger.trace("  Relative Humidity Max: {}", (Object)this.relativeHumidityMax);
        this.logger.trace("  Relative Humidity Min: {}", (Object)this.relativeHumidityMin);
        this.logger.trace("  Relative Humidity Mean: {}", (Object)this.relativeHumidityMean);
        this.logger.trace("  Convective Precipitation: {}", (Object)this.convectivePrecipitation);
        this.logger.trace("  Snowfall: {}", (Object)this.snowFall);
        this.logger.trace("  Precipitation Hours: {}", (Object)this.precipitationHours);
        this.logger.trace("  Humidity > 90 Hours: {}", (Object)this.humidityGreater90Hours);
    }

    public Object getDatapoint(String datapointName) {
        if (datapointName.equals("condition")) {
            return String.valueOf(this.pictocode);
        }
        try {
            Field field = this.getClass().getDeclaredField(datapointName);
            field.setAccessible(true);
            return field.get(this);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.logger.warn("Unable to find a datapoint declared for the name '{}'", (Object)datapointName);
            return null;
        }
        catch (Exception e) {
            this.logger.warn("An unexpected error occurred while trying to access the datapoint '{}'", (Object)datapointName, (Object)e);
            return null;
        }
    }

    public Integer getHeight() {
        return this.height;
    }

    public String getTimeUnits() {
        return this.timeUnits;
    }

    public String getPredictabilityUnits() {
        return this.predictabilityUnits;
    }

    public String getPrecipitationProbabilityUnits() {
        return this.precipitationProbabilityUnits;
    }

    public String getPressureUnits() {
        return this.pressureUnits;
    }

    public String getRelativeHumidityUnits() {
        return this.relativeHumidityUnits;
    }

    public String getTemperatureUnits() {
        return this.temperatureUnits;
    }

    public String getWindDirectionUnits() {
        return this.windDirectionUnits;
    }

    public String getPrecipitationUnits() {
        return this.precipitationUnits;
    }

    public String getWindSpeedUnits() {
        return this.windSpeedUnits;
    }

    public Calendar getForecastDate() {
        return this.forecastDate;
    }

    public Integer getPictocode() {
        return this.pictocode;
    }

    public Integer getUVIndex() {
        return this.UVIndex;
    }

    public Double getTemperatureMin() {
        return this.minTemperature;
    }

    public Double getTemperatureMax() {
        return this.maxTemperature;
    }

    public Double getTemperatureMean() {
        return this.meanTemperature;
    }

    public Double getFeltTemperatureMin() {
        return this.feltTemperatureMin;
    }

    public Double feltTemperatureMax() {
        return this.feltTemperatureMax;
    }

    public Integer getWindDirection() {
        return this.windDirection;
    }

    public String getCardinalWindDirection() {
        return this.cardinalWindDirection;
    }

    public Integer getPrecipitationProbability() {
        return this.precipitationProbability;
    }

    public String getRainSpot() {
        return this.rainSpot;
    }

    public Image getRainArea() {
        return this.rainArea;
    }

    public Integer getPredictabilityClass() {
        return this.predictabilityClass;
    }

    public Integer getPredictability() {
        return this.predictability;
    }

    public Double getPrecipitation() {
        return this.precipitation;
    }

    public Double getSnowFraction() {
        return this.snowFraction;
    }

    public Integer getSeaLevelPressureMin() {
        return this.minSeaLevelPressure;
    }

    public Integer getSeaLevelPressureMax() {
        return this.maxSeaLevelPressure;
    }

    public Integer getSeaLevelPressureMean() {
        return this.meanSeaLevelPressure;
    }

    public Double getWindSpeedMin() {
        return this.minWindSpeed;
    }

    public Double getWindSpeedMax() {
        return this.maxWindSpeed;
    }

    public Double getWindSpeedMean() {
        return this.meanWindSpeed;
    }

    public Integer getRelativeHumidityMin() {
        return this.relativeHumidityMin;
    }

    public Integer getRelativeHumidityMax() {
        return this.relativeHumidityMax;
    }

    public Integer getRelativeHumidityMean() {
        return this.relativeHumidityMean;
    }

    public Double getConvectivePrecipitation() {
        return this.convectivePrecipitation;
    }

    public Double getPrecipitationHours() {
        return this.precipitationHours;
    }

    public Double getHumidityGreater90Hours() {
        return this.humidityGreater90Hours;
    }

    private String getCardinalDirection(int degrees) {
        if (degrees > 337 || degrees < 23) {
            return "N";
        }
        if (degrees > 22 && degrees < 68) {
            return "NE";
        }
        if (degrees > 67 && degrees < 113) {
            return "E";
        }
        if (degrees > 112 && degrees < 158) {
            return "SE";
        }
        if (degrees > 157 && degrees < 203) {
            return "S";
        }
        if (degrees > 202 && degrees < 248) {
            return "SW";
        }
        if (degrees > 247 && degrees < 293) {
            return "W";
        }
        return "NW";
    }

    public Double getSnowFall() {
        return this.snowFall;
    }

    public Image getIcon() {
        return this.icon;
    }

    private String getIconNameForPictocode(int which) {
        if (which < 1 || which > 17) {
            return "iday.png";
        }
        return "iday-" + which + ".png";
    }

    private Image loadImageIcon(String imageFileName) {
        BufferedImage buf = null;
        File dataFile = new File(new File("../conf/icons/classic/"), imageFileName);
        if (!dataFile.exists()) {
            this.logger.debug("Image file '{}' does not exist. Unable to create imageIcon.", (Object)dataFile.getAbsolutePath());
            return null;
        }
        try {
            buf = ImageIO.read(dataFile);
            this.logger.trace("Returning image data: {}", (Object)buf);
            return buf;
        }
        catch (FileNotFoundException e) {
            this.logger.trace("Image file '{}' not found during read attempt", (Object)dataFile, (Object)e);
            return null;
        }
        catch (IOException e) {
            this.logger.debug("Failed to load image file '{}' for weather icon.", (Object)dataFile, (Object)e);
            return null;
        }
    }

    private Image generateRainAreaImage() {
        if (this.rainSpot == null) {
            this.logger.debug("No rainspot data exists. Can't generate rain area image.");
            return null;
        }
        String s42 = this.rainSpot.substring(42);
        String s35 = this.rainSpot.substring(35, 42);
        String s28 = this.rainSpot.substring(28, 35);
        String s21 = this.rainSpot.substring(21, 28);
        String s14 = this.rainSpot.substring(14, 21);
        String s07 = this.rainSpot.substring(7, 14);
        String s00 = this.rainSpot.substring(0, 7);
        char[] values = new char[49];
        s00.getChars(0, s00.length(), values, 42);
        s07.getChars(0, s07.length(), values, 35);
        s14.getChars(0, s14.length(), values, 28);
        s21.getChars(0, s21.length(), values, 21);
        s28.getChars(0, s28.length(), values, 14);
        s35.getChars(0, s35.length(), values, 7);
        s42.getChars(0, s42.length(), values, 0);
        this.logger.trace("Final grid: {}", (Object)values);
        BufferedImage buf = new BufferedImage(350, 350, 1);
        int gridCell = 0;
        int y = 0;
        while (y < 7) {
            int x = 0;
            while (x < 7) {
                gridCell = y * 7 + x;
                Color color = this.getColorForIndex(values[gridCell]);
                this.writeGrid(gridCell, buf, color);
                ++x;
            }
            ++y;
        }
        return buf;
    }

    private void writeGrid(int cell, BufferedImage img, Color color) {
        int startY;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int p = r << 16 | g << 8 | b;
        int startX = cell % 7 * 50;
        int i = startY = cell / 7 * 50;
        while (i < startY + 50) {
            int j = startX;
            while (j < startX + 50) {
                img.setRGB(j, i, p);
                ++j;
            }
            ++i;
        }
    }

    private Color getColorForIndex(char c) {
        switch (c) {
            case '0': {
                return Color.WHITE;
            }
            case '1': {
                return Color.GREEN;
            }
            case '2': {
                return Color.YELLOW;
            }
            case '3': {
                return Color.RED;
            }
            case '9': {
                return Color.decode("0x00FF00");
            }
        }
        return Color.BLACK;
    }
}

