/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.meteoblue.internal;

import org.apache.commons.lang.StringUtils;

public class MeteoBlueConfiguration {
    public static final int DEFAULT_REFRESH = 240;
    public static final String SERVICETYPE_COMM = "Commercial";
    public static final String SERVICETYPE_NONCOMM = "NonCommercial";
    public static final String COMM_BASE_URL = "http://my.meteoblue.com/dataApi/dispatch.pl?type=json_7day_3h_firstday&";
    public static final String NONCOMM_BASE_URL = "http://my.meteoblue.com/packages/basic-day?";
    public static final String URL_MINIMAL_PARAMS = "apikey=#API_KEY#&lat=#LATITUDE#&lon=#LONGITUDE#";
    public String serviceType;
    public String location;
    public Integer refresh;
    public Double latitude;
    public Double longitude;
    public Double altitude;
    public String timeZone;

    public static String getURL(String serviceType) {
        if (SERVICETYPE_COMM.equals(serviceType)) {
            return "http://my.meteoblue.com/dataApi/dispatch.pl?type=json_7day_3h_firstday&apikey=#API_KEY#&lat=#LATITUDE#&lon=#LONGITUDE##FORMAT_PARAMS#";
        }
        return "http://my.meteoblue.com/packages/basic-day?apikey=#API_KEY#&lat=#LATITUDE#&lon=#LONGITUDE##FORMAT_PARAMS#";
    }

    public void parseLocation() {
        String a3;
        String[] split = this.location.split(",");
        String a1 = split.length > 0 ? split[0] : null;
        String a2 = split.length > 1 ? split[1] : null;
        String string = a3 = split.length > 2 ? split[2] : null;
        if (!StringUtils.isBlank((String)a1)) {
            this.latitude = this.tryGetDouble(a1);
        }
        if (!StringUtils.isBlank((String)a2)) {
            this.longitude = this.tryGetDouble(a2);
        }
        if (!StringUtils.isBlank((String)a3)) {
            this.altitude = this.tryGetDouble(a3);
        }
    }

    private Double tryGetDouble(String toParse) {
        try {
            return Double.parseDouble(toParse);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

