/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.TextValue;
import org.eclipse.smarthome.core.thing.ThingUID;

@NonNullByDefault
public class ComponentAlarmControlPanel
extends AbstractComponent {
    public static final String stateChannelID = "alarm";
    public static final String switchDisarmChannelID = "disarm";
    public static final String switchArmHomeChannelID = "armhome";
    public static final String switchArmAwayChannelID = "armaway";
    protected Config config = new Config();

    public ComponentAlarmControlPanel(ThingUID thing, HaID haID, String configJSON, @Nullable ChannelStateUpdateListener channelStateUpdateListener, Gson gson) {
        super(thing, haID, configJSON, gson);
        this.config = (Config)gson.fromJson(configJSON, Config.class);
        String[] state_enum = new String[]{this.config.state_disarmed, this.config.state_armed_home, this.config.state_armed_away, this.config.state_pending, this.config.state_triggered};
        this.channels.put(stateChannelID, new CChannel(this, stateChannelID, new TextValue(state_enum), this.config.state_topic, null, this.config.name, "", channelStateUpdateListener));
        this.channels.put(switchDisarmChannelID, new CChannel(this, switchDisarmChannelID, new TextValue(new String[]{this.config.payload_disarm}), this.config.state_topic, null, this.config.name, "", channelStateUpdateListener));
        this.channels.put(switchArmHomeChannelID, new CChannel(this, switchArmHomeChannelID, new TextValue(new String[]{this.config.payload_arm_home}), this.config.state_topic, null, this.config.name, "", channelStateUpdateListener));
        this.channels.put(switchArmAwayChannelID, new CChannel(this, switchArmAwayChannelID, new TextValue(new String[]{this.config.payload_arm_away}), this.config.state_topic, null, this.config.name, "", channelStateUpdateListener));
    }

    @Override
    public String name() {
        return this.config.name;
    }

    static class Config {
        protected String name = "MQTT Alarm Control Panel";
        protected String icon = "";
        protected int qos = 1;
        protected boolean retain = true;
        protected @Nullable String value_template;
        protected @Nullable String unique_id;
        protected @Nullable String code;
        protected String state_topic = "";
        protected String state_disarmed = "disarmed";
        protected String state_armed_home = "armed_home";
        protected String state_armed_away = "armed_away";
        protected String state_pending = "pending";
        protected String state_triggered = "triggered";
        protected @Nullable String command_topic;
        protected String payload_disarm = "DISARM";
        protected String payload_arm_home = "ARM_HOME";
        protected String payload_arm_away = "ARM_AWAY";
        protected @Nullable String availability_topic;
        protected String payload_available = "online";
        protected String payload_not_available = "offline";

        Config() {
        }
    }
}

