/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.ColorValue;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;

@NonNullByDefault
public class ComponentLight
extends AbstractComponent
implements ChannelStateUpdateListener {
    public static final String switchChannelID = "light";
    public static final String brightnessChannelID = "brightness";
    public static final String colorChannelID = "color";
    protected Config config = new Config();
    protected CChannel colorChannel;
    protected CChannel switchChannel;
    protected CChannel brightnessChannel;
    private final @Nullable ChannelStateUpdateListener channelStateUpdateListener;

    public ComponentLight(ThingUID thing, HaID haID, String configJSON, @Nullable ChannelStateUpdateListener channelStateUpdateListener, Gson gson) {
        super(thing, haID, configJSON, gson);
        this.channelStateUpdateListener = channelStateUpdateListener;
        this.config = (Config)gson.fromJson(configJSON, Config.class);
        ColorValue value = new ColorValue(true, this.config.payload_on, this.config.payload_off, 100);
        this.switchChannel = new CChannel(this, switchChannelID, value, this.config.state_topic, this.config.command_topic, this.config.name, "", this);
        this.colorChannel = new CChannel(this, colorChannelID, value, this.config.rgb_state_topic, this.config.rgb_command_topic, this.config.name, "", this);
        this.brightnessChannel = new CChannel(this, brightnessChannelID, value, this.config.brightness_state_topic, this.config.brightness_command_topic, this.config.name, "", this);
        this.channels.put(switchChannelID, this.colorChannel);
    }

    @Override
    public CompletableFuture<@Nullable Void> start(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        return Stream.of(this.switchChannel, this.brightnessChannel, this.colorChannel).map(v -> v.channelState.start(connection, scheduler, timeout)).reduce(CompletableFuture.completedFuture(null), (f, v) -> f.thenCompose(b -> v));
    }

    @Override
    public CompletableFuture<@Nullable Void> stop() {
        return Stream.of(this.switchChannel, this.brightnessChannel, this.colorChannel).map(v -> v.channelState.stop()).reduce(CompletableFuture.completedFuture(null), (f, v) -> f.thenCompose(b -> v));
    }

    @Override
    public String name() {
        return this.config.name;
    }

    @Override
    public void updateChannelState(ChannelUID channelUID, State value) {
        ChannelStateUpdateListener listener = this.channelStateUpdateListener;
        if (listener != null) {
            listener.updateChannelState(this.colorChannel.channelUID, value);
        }
    }

    @Override
    public void postChannelCommand(ChannelUID channelUID, Command value) {
        ChannelStateUpdateListener listener = this.channelStateUpdateListener;
        if (listener != null) {
            listener.postChannelCommand(this.colorChannel.channelUID, value);
        }
    }

    @Override
    public void triggerChannel(ChannelUID channelUID, String eventPayload) {
        ChannelStateUpdateListener listener = this.channelStateUpdateListener;
        if (listener != null) {
            listener.triggerChannel(this.colorChannel.channelUID, eventPayload);
        }
    }

    static class Config {
        protected String name = "MQTT Light";
        protected String icon = "";
        protected int qos = 1;
        protected boolean retain = true;
        protected @Nullable String unique_id;
        protected int brightness_scale = 255;
        protected boolean optimistic = false;
        protected @Nullable List<String> effect_list;
        protected String on_command_type = "last";
        protected @Nullable String state_topic;
        protected @Nullable String command_topic;
        protected @Nullable String state_value_template;
        protected @Nullable String brightness_state_topic;
        protected @Nullable String brightness_command_topic;
        protected @Nullable String brightness_value_template;
        protected @Nullable String color_temp_state_topic;
        protected @Nullable String color_temp_command_topic;
        protected @Nullable String color_temp_value_template;
        protected @Nullable String effect_command_topic;
        protected @Nullable String effect_state_topic;
        protected @Nullable String effect_value_template;
        protected @Nullable String rgb_command_topic;
        protected @Nullable String rgb_state_topic;
        protected @Nullable String rgb_value_template;
        protected @Nullable String rgb_command_template;
        protected @Nullable String white_value_command_topic;
        protected @Nullable String white_value_state_topic;
        protected @Nullable String white_value_template;
        protected @Nullable String xy_command_topic;
        protected @Nullable String xy_state_topic;
        protected @Nullable String xy_value_template;
        protected String payload_on = "ON";
        protected String payload_off = "OFF";
        protected @Nullable String availability_topic;
        protected String payload_available = "online";
        protected String payload_not_available = "offline";

        Config() {
        }
    }
}

