/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant;

import com.google.gson.Gson;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.AbstractComponent;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.CChannel;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homeassistant.HaID;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.TextValue;
import org.eclipse.smarthome.core.thing.ThingUID;

@NonNullByDefault
public class ComponentSensor
extends AbstractComponent {
    public static final String sensorChannelID = "sensor";
    protected Config config = new Config();

    public ComponentSensor(ThingUID thing, HaID haID, String configJSON, @Nullable ChannelStateUpdateListener channelStateUpdateListener, Gson gson) {
        super(thing, haID, configJSON, gson);
        this.config = (Config)gson.fromJson(configJSON, Config.class);
        if (this.config.force_update) {
            throw new UnsupportedOperationException("Component:Sensor does not support forced updates");
        }
        this.channels.put(sensorChannelID, new CChannel(this, sensorChannelID, new TextValue(), this.config.state_topic, null, this.config.name, this.config.unit_of_measurement, channelStateUpdateListener));
    }

    @Override
    public String name() {
        return this.config.name;
    }

    static class Config {
        protected String name = "MQTT Sensor";
        protected String icon = "";
        protected int qos = 1;
        protected boolean retain = true;
        protected @Nullable String value_template;
        protected @Nullable String unique_id;
        protected String unit_of_measurement = "";
        protected @Nullable String device_class;
        protected boolean force_update = false;
        protected int expire_after = 0;
        protected String state_topic = "";
        protected @Nullable String availability_topic;
        protected String payload_available = "online";
        protected String payload_not_available = "offline";

        Config() {
        }
    }
}

