/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.DeviceCallback;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.NodeAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.Property;
import org.eclipse.smarthome.binding.mqtt.generic.internal.convention.homie300.PropertyAttributes;
import org.eclipse.smarthome.binding.mqtt.generic.internal.mapping.AbstractMqttAttributeClass;
import org.eclipse.smarthome.binding.mqtt.generic.internal.tools.ChildMap;
import org.eclipse.smarthome.core.thing.ChannelGroupUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.type.ChannelDefinitionBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Node
implements AbstractMqttAttributeClass.AttributeChanged {
    private final Logger logger = LoggerFactory.getLogger(Node.class);
    public final String nodeID;
    public final NodeAttributes attributes;
    public ChildMap<Property> properties;
    public final DeviceCallback callback;
    protected final ChannelGroupUID channelGroupUID;
    public final ChannelGroupTypeUID channelGroupTypeUID;
    private final String topic;
    private boolean initialized = false;

    public Node(String topic, String nodeID, ThingUID thingUID, DeviceCallback callback, NodeAttributes attributes) {
        this.attributes = attributes;
        this.topic = String.valueOf(topic) + "/" + nodeID;
        this.nodeID = nodeID;
        this.callback = callback;
        this.channelGroupTypeUID = new ChannelGroupTypeUID("mqtt", this.topic.replace('/', '_'));
        this.channelGroupUID = new ChannelGroupUID(thingUID, nodeID);
        this.properties = new ChildMap();
    }

    public CompletableFuture<@Nullable Void> subscribe(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        return ((CompletableFuture)this.attributes.subscribeAndReceive(connection, scheduler, this.topic, this, timeout).thenCompose(b -> this.attributesReceived(connection, scheduler, timeout))).whenComplete((r, e) -> {
            this.initialized = true;
        });
    }

    public CompletableFuture<@Nullable Void> attributesReceived(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        this.callback.nodeAddedOrChanged(this);
        return this.applyProperties(connection, scheduler, timeout);
    }

    public void nodeRestoredFromConfig() {
        this.initialized = true;
    }

    public CompletableFuture<@Nullable Void> stop() {
        return this.attributes.unsubscribe().thenCompose(b -> CompletableFuture.allOf((CompletableFuture[])this.properties.stream().map(p -> p.stop()).toArray(CompletableFuture[]::new)));
    }

    public ChannelGroupType type() {
        List channelDefinitions = this.properties.stream().map(c -> new ChannelDefinitionBuilder(c.propertyID, c.channelTypeUID).build()).collect(Collectors.toList());
        return ChannelGroupTypeBuilder.instance((ChannelGroupTypeUID)this.channelGroupTypeUID, (String)this.attributes.name).withChannelDefinitions(channelDefinitions).build();
    }

    public ChannelGroupUID uid() {
        return this.channelGroupUID;
    }

    public Property createProperty(String propertyID) {
        return new Property(this.topic, this, propertyID, this.callback, new PropertyAttributes());
    }

    public Property createProperty(String propertyID, PropertyAttributes attributes) {
        return new Property(this.topic, this, propertyID, this.callback, attributes);
    }

    protected void notifyPropertyRemoved(Property property) {
        property.stop();
        this.callback.propertyRemoved(property);
    }

    protected CompletableFuture<@Nullable Void> applyProperties(MqttBrokerConnection connection, ScheduledExecutorService scheduler, int timeout) {
        return this.properties.apply(this.attributes.properties, prop -> prop.subscribe(connection, scheduler, timeout), this::createProperty, this::notifyPropertyRemoved).exceptionally(e -> {
            this.logger.warn("Could not subscribe", e);
            return null;
        });
    }

    @Override
    public void attributeChanged(String name, Object value, MqttBrokerConnection connection, ScheduledExecutorService scheduler, boolean allMandatoryFieldsReceived) {
        if (!this.initialized || !allMandatoryFieldsReceived) {
            return;
        }
        if (!this.attributes.isComplete()) {
            this.attributesReceived(connection, scheduler, 500);
        } else if ("properties".equals(name)) {
            this.applyProperties(connection, scheduler, 500);
        }
        this.callback.nodeAddedOrChanged(this);
    }

    public String toString() {
        return this.channelGroupUID.toString();
    }
}

