/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.discovery;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryParticipant;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryService;
import org.eclipse.smarthome.binding.mqtt.generic.internal.MqttBindingConstants;
import org.eclipse.smarthome.binding.mqtt.generic.internal.discovery.AbstractMQTTDiscovery;
import org.eclipse.smarthome.binding.mqtt.generic.internal.tools.WaitForTopicValue;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.mqtthomie")
@NonNullByDefault
public class Homie300Discovery
extends AbstractMQTTDiscovery {
    private final Logger logger = LoggerFactory.getLogger(Homie300Discovery.class);
    @NonNullByDefault(value={})
    protected MQTTTopicDiscoveryService mqttTopicDiscovery;

    public Homie300Discovery() {
        super(Stream.of(MqttBindingConstants.HOMIE300_MQTT_THING).collect(Collectors.toSet()), 3, true, "+/+/$homie");
    }

    @Reference
    public void setMQTTTopicDiscoveryService(MQTTTopicDiscoveryService service) {
        this.mqttTopicDiscovery = service;
    }

    public void unsetMQTTTopicDiscoveryService(@Nullable MQTTTopicDiscoveryService service) {
        this.mqttTopicDiscovery.unsubscribe((MQTTTopicDiscoveryParticipant)this);
        this.mqttTopicDiscovery = null;
    }

    @Override
    protected MQTTTopicDiscoveryService getDiscoveryService() {
        return this.mqttTopicDiscovery;
    }

    public static @Nullable String extractDeviceID(String topic) {
        String[] strings = topic.split("/");
        if (strings.length > 2) {
            return strings[1];
        }
        return null;
    }

    public static boolean checkVersion(byte[] payload) {
        return payload.length > 0 && (payload[0] == 51 || payload[0] == 52);
    }

    public void receivedMessage(ThingUID connectionBridge, MqttBrokerConnection connection, String topic, byte[] payload) {
        if (!Homie300Discovery.checkVersion(payload)) {
            this.logger.trace("Found homie device. But version {} is out of range.", (Object)new String(payload, StandardCharsets.UTF_8));
            return;
        }
        String deviceID = Homie300Discovery.extractDeviceID(topic);
        if (deviceID == null) {
            this.logger.trace("Found homie device. But deviceID {} is invalid.", (Object)deviceID);
            return;
        }
        this.publishDevice(connectionBridge, connection, deviceID, topic);
        try {
            WaitForTopicValue w = new WaitForTopicValue(connection, topic.replace("$homie", "$name"));
            w.waitForTopicValueAsync(this.scheduler, 700).thenAccept(name -> this.publishDevice(connectionBridge, connection, deviceID, (String)name));
        }
        catch (InterruptedException | ExecutionException exception) {}
    }

    void publishDevice(ThingUID connectionBridge, MqttBrokerConnection connection, String deviceID, String topic) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("deviceid", deviceID);
        properties.put("basetopic", topic.substring(0, topic.indexOf("/")));
        this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)new ThingUID(MqttBindingConstants.HOMIE300_MQTT_THING, connectionBridge, deviceID)).withBridge(connectionBridge).withProperties(properties).withRepresentationProperty("deviceid").withLabel(deviceID).build());
    }

    public void topicVanished(ThingUID connectionBridge, MqttBrokerConnection connection, String topic) {
        String deviceID = Homie300Discovery.extractDeviceID(topic);
        if (deviceID == null) {
            return;
        }
        this.thingRemoved(new ThingUID(MqttBindingConstants.HOMIE300_MQTT_THING, connectionBridge, deviceID));
    }
}

