/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelState;
import org.eclipse.smarthome.binding.mqtt.generic.internal.generic.ChannelStateUpdateListener;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractMQTTThingHandler
extends BaseThingHandler
implements ChannelStateUpdateListener {
    private final Logger logger = LoggerFactory.getLogger(AbstractMQTTThingHandler.class);
    private final int subscribeTimeout;
    protected @Nullable MqttBrokerConnection connection;

    public AbstractMQTTThingHandler(Thing thing, int subscribeTimeout) {
        super(thing);
        this.subscribeTimeout = subscribeTimeout;
    }

    public abstract @Nullable ChannelState getChannelState(ChannelUID var1);

    protected abstract CompletableFuture<@Nullable Void> start(MqttBrokerConnection var1);

    protected void stop() {
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (this.connection == null) {
            return;
        }
        @Nullable ChannelState data = this.getChannelState(channelUID);
        if (data == null) {
            this.logger.warn("Channel {} not supported", (Object)channelUID.getId());
            if (command instanceof RefreshType) {
                this.updateState(channelUID.getId(), (State)UnDefType.UNDEF);
            }
            return;
        }
        if (command instanceof RefreshType || data.isReadOnly()) {
            this.updateState(channelUID.getId(), data.getCache().getChannelState());
            return;
        }
        CompletableFuture<@Nullable Void> future = data.publishValue(command);
        ((CompletableFuture)future.exceptionally(e -> {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getLocalizedMessage());
            return null;
        })).thenRun(() -> this.logger.debug("Successfully published value {} to topic {}", (Object)command, (Object)data.getStateTopic()));
    }

    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        MqttBrokerConnection connection;
        if (bridgeStatusInfo.getStatus() == ThingStatus.OFFLINE) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
            this.stop();
            this.connection = null;
            return;
        }
        if (bridgeStatusInfo.getStatus() != ThingStatus.ONLINE) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
            this.stop();
            return;
        }
        AbstractBrokerHandler h = this.getBridgeHandler();
        if (h == null) {
            this.logger.warn("Bridge handler not found!");
            return;
        }
        try {
            connection = (MqttBrokerConnection)h.getConnectionAsync().get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_UNINITIALIZED, "Bridge handler has no valid broker connection!");
            return;
        }
        this.connection = connection;
        try {
            ((CompletableFuture)((CompletableFuture)this.start(connection).thenApply(e -> true)).exceptionally(e -> {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getLocalizedMessage());
                return null;
            })).get(this.subscribeTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "Did not receive all required topics");
        }
    }

    public @Nullable AbstractBrokerHandler getBridgeHandler() {
        Bridge bridge = this.getBridge();
        if (bridge == null) {
            return null;
        }
        return (AbstractBrokerHandler)bridge.getHandler();
    }

    public ThingStatusInfo getBridgeStatus() {
        Bridge b = this.getBridge();
        if (b != null) {
            return b.getStatusInfo();
        }
        return new ThingStatusInfo(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE, null);
    }

    public void initialize() {
        this.bridgeStatusChanged(this.getBridgeStatus());
    }

    public void handleRemoval() {
        this.stop();
        super.handleRemoval();
    }

    public void dispose() {
        MqttBrokerConnection connection = this.connection;
        if (connection != null) {
            connection.unsubscribeAll();
        }
        super.dispose();
    }

    @Override
    public void updateChannelState(ChannelUID channelUID, State value) {
        super.updateState(channelUID, value);
    }

    @Override
    public void triggerChannel(ChannelUID channelUID, String event) {
        super.triggerChannel(channelUID, event);
    }

    @Override
    public void postChannelCommand(ChannelUID channelUID, Command command) {
        this.postCommand(channelUID, command);
    }
}

