/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.mapping;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.mapping.MQTTvalueTransform;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class SubscribeFieldToMQTTtopic
implements MqttMessageSubscriber {
    private final Logger logger = LoggerFactory.getLogger(SubscribeFieldToMQTTtopic.class);
    protected CompletableFuture<@Nullable Void> future = new CompletableFuture();
    public final Field field;
    public final FieldChanged changeConsumer;
    public final String topic;
    private final ScheduledExecutorService scheduler;
    private @Nullable ScheduledFuture<?> scheduledFuture;
    private final boolean mandatory;
    private boolean receivedValue = false;

    public SubscribeFieldToMQTTtopic(ScheduledExecutorService scheduler, Field field, FieldChanged fieldChangeListener, String topic, boolean mandatory) {
        this.scheduler = scheduler;
        this.field = field;
        this.changeConsumer = fieldChangeListener;
        this.topic = topic;
        this.mandatory = mandatory;
    }

    static Object numberConvert(Object value, Class<?> type) throws IllegalArgumentException, NumberFormatException {
        Object result = value;
        String typeName = type.getSimpleName();
        if (value instanceof BigDecimal && !type.equals(BigDecimal.class)) {
            BigDecimal bdValue = (BigDecimal)value;
            if (type.equals(Float.class) || typeName.equals("float")) {
                result = Float.valueOf(bdValue.floatValue());
            } else if (type.equals(Double.class) || typeName.equals("double")) {
                result = bdValue.doubleValue();
            } else if (type.equals(Long.class) || typeName.equals("long")) {
                result = bdValue.longValue();
            } else if (type.equals(Integer.class) || typeName.equals("int")) {
                result = bdValue.intValue();
            }
        } else if (value instanceof String && !type.equals(String.class)) {
            String bdValue = (String)value;
            if (type.equals(Float.class) || typeName.equals("float")) {
                result = Float.valueOf(bdValue);
            } else if (type.equals(Double.class) || typeName.equals("double")) {
                result = Double.valueOf(bdValue);
            } else if (type.equals(Long.class) || typeName.equals("long")) {
                result = Long.valueOf(bdValue);
            } else if (type.equals(BigDecimal.class)) {
                result = new BigDecimal(bdValue);
            } else if (type.equals(Integer.class) || typeName.equals("int")) {
                result = Integer.valueOf(bdValue);
            } else if (type.equals(Boolean.class) || typeName.equals("boolean")) {
                result = Boolean.valueOf(bdValue);
            } else if (type.isEnum()) {
                Class<?> enumType = type;
                Object enumValue = Enum.valueOf(enumType, value.toString());
                result = enumValue;
            }
        }
        return result;
    }

    public void processMessage(@NonNull String topic, byte @NonNull [] payload) {
        Object value;
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        String valueStr = new String(payload, StandardCharsets.UTF_8);
        MQTTvalueTransform transform = this.field.getAnnotation(MQTTvalueTransform.class);
        if (transform != null) {
            valueStr = String.valueOf(transform.prefix()) + valueStr + transform.suffix();
            value = this.field.getType().isArray() ? valueStr.split(transform.splitCharacter()) : SubscribeFieldToMQTTtopic.numberConvert(valueStr, this.field.getType());
        } else {
            if (this.field.getType().isArray()) {
                throw new IllegalArgumentException("No split character defined!");
            }
            value = SubscribeFieldToMQTTtopic.numberConvert(valueStr, this.field.getType());
        }
        this.receivedValue = true;
        this.changeConsumer.fieldChanged(this.field, value);
        this.future.complete(null);
    }

    void timeoutReached() {
        if (this.mandatory) {
            this.future.completeExceptionally(new Exception("Did not receive mandatory topic value: " + this.topic));
        } else {
            this.future.complete(null);
        }
    }

    public CompletableFuture<@Nullable Void> subscribeAndReceive(MqttBrokerConnection connection, int timeout) {
        ((CompletableFuture)connection.subscribe(this.topic, (MqttMessageSubscriber)this).exceptionally(e -> {
            this.logger.debug("Failed to subscribe to topic {}", (Object)this.topic, e);
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
                this.scheduledFuture = null;
            }
            this.future.complete(null);
            return false;
        })).thenRun(() -> {
            if (!this.future.isDone()) {
                this.scheduledFuture = this.scheduler.schedule(this::timeoutReached, (long)timeout, TimeUnit.MILLISECONDS);
            }
        });
        return this.future;
    }

    public boolean hasReceivedValue() {
        return this.receivedValue;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public static interface FieldChanged {
        public void fieldChanged(Field var1, Object var2);
    }
}

