/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.tools;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class ChildMap<TYPE> {
    protected Map<String, TYPE> map = new TreeMap<String, TYPE>();

    public Stream<TYPE> stream() {
        return this.map.values().stream();
    }

    public CompletableFuture<@Nullable Void> apply(String[] childIDs, Function<TYPE, CompletableFuture<Void>> addedAction, Function<String, TYPE> supplyNewChild, Consumer<TYPE> removedCallback) {
        Set arrayValues = Stream.of(childIDs).collect(Collectors.toSet());
        Map<String, Object> newSubnodes = arrayValues.stream().filter(entry -> !this.map.containsKey(entry)).collect(Collectors.toMap(k -> k, k -> supplyNewChild.apply((String)k)));
        this.map.putAll(newSubnodes);
        this.map.entrySet().removeIf(entry -> {
            if (!arrayValues.contains(entry.getKey())) {
                removedCallback.accept(entry.getValue());
                return true;
            }
            return false;
        });
        return CompletableFuture.allOf((CompletableFuture[])newSubnodes.values().stream().map(v -> (CompletableFuture)addedAction.apply(v)).toArray(CompletableFuture[]::new));
    }

    public int size() {
        return this.map.size();
    }

    public TYPE get(@Nullable String key) {
        return this.map.get(key);
    }

    public void clear() {
        this.map.clear();
    }

    public void put(String key, TYPE value) {
        this.map.put(key, value);
    }
}

