/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class DateTimeValue
extends Value {
    public DateTimeValue() {
        super("DateTime", Stream.of(DateTimeType.class, StringType.class).collect(Collectors.toList()));
    }

    @Override
    public void update(Command command) throws IllegalArgumentException {
        this.state = command instanceof DateTimeType ? (DateTimeType)command : DateTimeType.valueOf((String)command.toString());
    }

    @Override
    public String getMQTTpublishValue() {
        if (this.state == UnDefType.UNDEF) {
            return "";
        }
        return ((DateTimeType)this.state).getZonedDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }
}

