/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;

@NonNullByDefault
public class OnOffValue
extends Value {
    private final String onString;
    private final String offString;

    public OnOffValue() {
        super("Switch", Stream.of(OnOffType.class, StringType.class).collect(Collectors.toList()));
        this.onString = OnOffType.ON.name();
        this.offString = OnOffType.OFF.name();
    }

    public OnOffValue(@Nullable String onValue, @Nullable String offValue) {
        super("Switch", Stream.of(OnOffType.class, StringType.class).collect(Collectors.toList()));
        this.onString = onValue == null ? OnOffType.ON.name() : onValue;
        this.offString = offValue == null ? OnOffType.OFF.name() : offValue;
    }

    @Override
    public void update(Command command) throws IllegalArgumentException {
        String updatedValue;
        this.state = command instanceof OnOffType ? (OnOffType)command : (this.onString.equals(updatedValue = command.toString()) ? OnOffType.ON : (this.offString.equals(updatedValue) ? OnOffType.OFF : OnOffType.valueOf((String)updatedValue)));
    }

    @Override
    public String getMQTTpublishValue() {
        return this.state == OnOffType.ON ? this.onString : this.offString;
    }
}

