/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class PercentageValue
extends Value {
    private final double min;
    private final double max;
    private final double step;
    private final @Nullable String onValue;
    private final @Nullable String offValue;

    public PercentageValue(@Nullable BigDecimal min, @Nullable BigDecimal max, @Nullable BigDecimal step, @Nullable String onValue, @Nullable String offValue) {
        super("Dimmer", Stream.of(DecimalType.class, IncreaseDecreaseType.class, OnOffType.class, UpDownType.class, StringType.class).collect(Collectors.toList()));
        this.onValue = onValue;
        this.offValue = offValue;
        this.min = min == null ? 0.0 : min.doubleValue();
        double d = this.max = max == null ? 100.0 : max.doubleValue();
        if (this.min >= this.max) {
            throw new IllegalArgumentException("Min need to be smaller than max!");
        }
        this.step = step == null ? 1.0 : step.doubleValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Command command) throws IllegalArgumentException {
        PercentType oldvalue;
        PercentType percentType = oldvalue = this.state == UnDefType.UNDEF ? new PercentType() : (PercentType)this.state;
        if (command instanceof PercentType) {
            this.state = (PercentType)command;
            return;
        } else if (command instanceof DecimalType) {
            double v = ((DecimalType)command).doubleValue();
            v = (v - this.min) * 100.0 / (this.max - this.min);
            this.state = new PercentType(new BigDecimal(v));
            return;
        } else if (command instanceof IncreaseDecreaseType) {
            double v;
            this.state = (IncreaseDecreaseType)command == IncreaseDecreaseType.INCREASE ? new PercentType(new BigDecimal((v = oldvalue.doubleValue() + this.step) <= this.max ? v : this.max)) : new PercentType(new BigDecimal((v = oldvalue.doubleValue() - this.step) >= this.min ? v : this.min));
            return;
        } else if (command instanceof OnOffType) {
            this.state = (OnOffType)command == OnOffType.ON ? PercentType.HUNDRED : PercentType.ZERO;
            return;
        } else if (command instanceof UpDownType) {
            double v;
            this.state = (UpDownType)command == UpDownType.UP ? new PercentType(new BigDecimal((v = oldvalue.doubleValue() + this.step) <= this.max ? v : this.max)) : new PercentType(new BigDecimal((v = oldvalue.doubleValue() - this.step) >= this.min ? v : this.min));
            return;
        } else if (command instanceof StringType) {
            if (this.onValue != null && command.toString().equals(this.onValue)) {
                this.state = new PercentType(new BigDecimal(this.max));
                return;
            } else {
                if (this.offValue == null || !command.toString().equals(this.offValue)) throw new IllegalStateException("Unknown String!");
                this.state = new PercentType(new BigDecimal(this.min));
            }
            return;
        } else {
            this.state = PercentType.valueOf((String)command.toString());
        }
    }

    @Override
    public String getMQTTpublishValue() {
        if (this.state == UnDefType.UNDEF) {
            return "";
        }
        return ((PercentType)this.state).toBigDecimal().multiply(BigDecimal.valueOf(this.max)).divide(BigDecimal.valueOf(100L)).add(BigDecimal.valueOf(this.min)).toString();
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        return new StateDescription(new BigDecimal(this.min), new BigDecimal(this.max), new BigDecimal(this.step), "%s " + unit.replace("%", "%%"), readOnly, Collections.emptyList());
    }
}

