/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.generic.internal.values.Value;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;

@NonNullByDefault
public class TextValue
extends Value {
    private final @Nullable Set<String> states;

    public TextValue(String[] states) {
        super("String", Collections.singletonList(StringType.class));
        Set s = Stream.of(states).filter(e -> StringUtils.isNotBlank((String)e)).collect(Collectors.toSet());
        this.states = s.size() > 0 ? s : null;
    }

    public TextValue() {
        super("String", Collections.singletonList(StringType.class));
        this.states = null;
    }

    @Override
    public void update(Command command) throws IllegalArgumentException {
        Set<String> states = this.states;
        String valueStr = command.toString();
        if (states != null && !states.contains(valueStr)) {
            throw new IllegalArgumentException("Value " + valueStr + " not within range");
        }
        this.state = new StringType(valueStr);
    }

    public @Nullable Set<String> getStates() {
        return this.states;
    }

    @Override
    public StateDescription createStateDescription(String unit, boolean readOnly) {
        ArrayList<StateOption> stateOptions = new ArrayList<StateOption>();
        Set<String> states = this.states;
        if (states != null) {
            for (String state : states) {
                stateOptions.add(new StateOption(state, state));
            }
        }
        return new StateDescription(null, null, null, "%s " + unit.replace("%", "%%"), readOnly, stateOptions);
    }
}

