/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.generic.internal.values;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public abstract class Value {
    protected State state = UnDefType.UNDEF;
    protected final List<Class<? extends Command>> commandTypes;
    private final String itemType;

    protected Value(String itemType, List<Class<? extends Command>> commandTypes) {
        this.itemType = itemType;
        this.commandTypes = commandTypes;
    }

    public final List<Class<? extends Command>> getSupportedCommandTypes() {
        return this.commandTypes;
    }

    public final String getItemType() {
        return this.itemType;
    }

    public final State getChannelState() {
        return this.state;
    }

    public String getMQTTpublishValue() {
        return this.state.toString();
    }

    public boolean isBinary() {
        return false;
    }

    public final void resetState() {
        this.state = UnDefType.UNDEF;
    }

    public abstract void update(Command var1) throws IllegalArgumentException;

    public @Nullable Command isPostOnly(Command command) {
        return null;
    }

    public void update(byte[] data) throws IllegalArgumentException {
        String mimeType = null;
        if (data.length >= 2 && data[0] == -1 && data[1] == -40 && data[data.length - 2] == -1 && data[data.length - 1] == -39) {
            mimeType = "image/jpeg";
        } else {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
                    try {
                        mimeType = URLConnection.guessContentTypeFromStream(input);
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        this.state = new RawType(data, mimeType == null ? "application/octet-stream" : mimeType);
    }

    public StateDescription createStateDescription(String unit, boolean readOnly) {
        return new StateDescription(null, null, null, "%s " + unit.replace("%", "%%"), readOnly, Collections.emptyList());
    }
}

