/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.action;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.annotation.ActionInput;
import org.eclipse.smarthome.automation.annotation.RuleAction;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.core.thing.binding.ThingActions;
import org.eclipse.smarthome.core.thing.binding.ThingActionsScope;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThingActionsScope(name="mqtt")
@NonNullByDefault
public class MQTTActions
implements ThingActions {
    private final Logger logger = LoggerFactory.getLogger(MQTTActions.class);
    private @Nullable AbstractBrokerHandler handler;

    public void setThingHandler(@Nullable ThingHandler handler) {
        this.handler = (AbstractBrokerHandler)handler;
    }

    public @Nullable ThingHandler getThingHandler() {
        return this.handler;
    }

    @RuleAction(label="@text/actionLabel", description="@text/actionDesc")
    public void publishMQTT(@ActionInput(name="topic", label="@text/actionInputTopicLabel", description="@text/actionInputTopicDesc") @Nullable String topic, @ActionInput(name="value", label="@text/actionInputValueLabel", description="@text/actionInputValueDesc") @Nullable String value) {
        AbstractBrokerHandler brokerHandler = this.handler;
        if (brokerHandler == null) {
            this.logger.warn("MQTT Action service ThingHandler is null!");
            return;
        }
        MqttBrokerConnection connection = brokerHandler.getConnection();
        if (connection == null) {
            this.logger.warn("MQTT Action service ThingHandler connection is null!");
            return;
        }
        if (value == null) {
            this.logger.debug("skipping MQTT publishing to topic '{}' due to null value.", (Object)topic);
            return;
        }
        if (topic == null) {
            this.logger.debug("skipping MQTT publishing of value '{}' as topic is null.", (Object)value);
            return;
        }
        ((CompletableFuture)connection.publish(topic, value.getBytes()).thenRun(() -> this.logger.debug("MQTT publish to {} performed", (Object)topic))).exceptionally(e -> {
            this.logger.warn("MQTT publish to {} failed!", (Object)topic);
            return null;
        });
    }

    public static void publishMQTT(@Nullable ThingActions actions, @Nullable String topic, @Nullable String value) {
        if (!(actions instanceof MQTTActions)) {
            throw new IllegalArgumentException("Instance is not an MQTTActions class.");
        }
        ((MQTTActions)actions).publishMQTT(topic, value);
    }
}

