/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.handler;

import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.binding.mqtt.handler.BrokerHandlerConfig;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.Pin;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinMessageDigest;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinTrustManager;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinType;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinnedCallback;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinningSSLContextProvider;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.util.HexUtils;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionState;
import org.eclipse.smarthome.io.transport.mqtt.MqttWillAndTestament;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.AbstractReconnectStrategy;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.PeriodicReconnectStrategy;
import org.eclipse.smarthome.io.transport.mqtt.sslcontext.SSLContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class BrokerHandler
extends AbstractBrokerHandler
implements PinnedCallback {
    private final Logger logger = LoggerFactory.getLogger(BrokerHandler.class);
    protected BrokerHandlerConfig config = new BrokerHandlerConfig();

    public BrokerHandler(Bridge thing) {
        super(thing);
    }

    @Override
    public void connectionStateChanged(MqttConnectionState state, @Nullable Throwable error) {
        super.connectionStateChanged(state, error);
        MqttBrokerConnection connection = this.connection;
        if (connection != null && state == MqttConnectionState.CONNECTED && StringUtils.isBlank((String)this.config.clientID)) {
            this.config.clientID = connection.getClientId();
            Configuration editConfig = this.editConfiguration();
            editConfig.put("clientid", (Object)this.config.clientID);
            this.updateConfiguration(editConfig);
        }
    }

    @Override
    public void pinnedLearnedHash(Pin pin) {
        byte[] hash = pin.getHash();
        if (hash == null) {
            this.logger.error("Received pins hash is empty!");
            return;
        }
        String configKey = null;
        try {
            switch (pin.getType()) {
                case CERTIFICATE_TYPE: {
                    configKey = BrokerHandlerConfig.class.getDeclaredField("certificate").getName();
                    break;
                }
                case PUBLIC_KEY_TYPE: {
                    configKey = BrokerHandlerConfig.class.getDeclaredField("publickey").getName();
                }
            }
        }
        catch (NoSuchFieldException e) {
            this.logger.error("Field name changed!", (Throwable)e);
            return;
        }
        Configuration thingConfig = this.editConfiguration();
        thingConfig.put(configKey, (Object)HexUtils.bytesToHex((byte[])hash));
        this.updateConfiguration(thingConfig);
    }

    @Override
    public void pinnedConnectionDenied(Pin pin) {
    }

    @Override
    public void pinnedConnectionAccepted() {
    }

    @Override
    public void dispose() {
        try {
            this.connection.stop().get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {}
        super.dispose();
    }

    protected void assignSSLContextProvider(BrokerHandlerConfig config, MqttBrokerConnection connection, PinnedCallback callback) throws IllegalArgumentException {
        String[] split;
        Pin pin;
        PinTrustManager trustManager = new PinTrustManager();
        connection.setSSLContextProvider((SSLContextProvider)new PinningSSLContextProvider(trustManager));
        trustManager.setCallback(callback);
        if (config.certificatepin) {
            try {
                if (StringUtils.isBlank((String)config.certificate)) {
                    pin = Pin.LearningPin(PinType.CERTIFICATE_TYPE);
                } else {
                    split = config.certificate.split(":");
                    if (split.length != 2) {
                        throw new NoSuchAlgorithmException("Algorithm is missing");
                    }
                    pin = Pin.CheckingPin(PinType.CERTIFICATE_TYPE, new PinMessageDigest(split[0]), HexUtils.hexToBytes((String)split[1]));
                }
                trustManager.addPinning(pin);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (config.publickeypin) {
            try {
                if (StringUtils.isBlank((String)config.publickey)) {
                    pin = Pin.LearningPin(PinType.PUBLIC_KEY_TYPE);
                } else {
                    split = config.publickey.split(":");
                    if (split.length != 2) {
                        throw new NoSuchAlgorithmException("Algorithm is missing");
                    }
                    pin = Pin.CheckingPin(PinType.PUBLIC_KEY_TYPE, new PinMessageDigest(split[0]), HexUtils.hexToBytes((String)split[1]));
                }
                trustManager.addPinning(pin);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected MqttBrokerConnection createBrokerConnection() throws IllegalArgumentException {
        Integer keepAlive;
        String topic;
        String host = this.config.host;
        if (StringUtils.isBlank((String)host) || host == null) {
            throw new IllegalArgumentException("Host is empty!");
        }
        MqttBrokerConnection connection = new MqttBrokerConnection(host, this.config.port, this.config.secure, this.config.clientID);
        String username = this.config.username;
        String password = this.config.password;
        if (StringUtils.isNotBlank((String)username) && password != null) {
            connection.setCredentials(username, password);
        }
        if ((topic = this.config.lwtTopic) != null) {
            String msg = this.config.lwtMessage;
            MqttWillAndTestament will = new MqttWillAndTestament(topic, msg != null ? msg.getBytes() : null, this.config.lwtQos.intValue(), this.config.lwtRetain.booleanValue());
            connection.setLastWill(will);
        }
        connection.setQos(this.config.qos.intValue());
        if (this.config.reconnectTime != null) {
            connection.setReconnectStrategy((AbstractReconnectStrategy)new PeriodicReconnectStrategy(this.config.reconnectTime.intValue(), 10000));
        }
        if ((keepAlive = this.config.keepAlive) != null) {
            connection.setKeepAliveInterval(keepAlive.intValue());
        }
        if (this.config.timeoutInMs != null) {
            connection.setTimeoutExecutor(this.scheduler, TIMEOUT_DEFAULT);
        }
        connection.setRetain(this.config.retainMessages.booleanValue());
        return connection;
    }

    @Override
    public void initialize() {
        this.config = (BrokerHandlerConfig)((Object)this.getConfigAs(BrokerHandlerConfig.class));
        this.connection = this.createBrokerConnection();
        this.assignSSLContextProvider(this.config, this.connection, this);
        super.initialize();
    }
}

