/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.MqttBindingConstants;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryParticipant;
import org.eclipse.smarthome.binding.mqtt.discovery.MQTTTopicDiscoveryService;
import org.eclipse.smarthome.binding.mqtt.handler.AbstractBrokerHandler;
import org.eclipse.smarthome.binding.mqtt.handler.BrokerHandler;
import org.eclipse.smarthome.binding.mqtt.handler.SystemBrokerHandler;
import org.eclipse.smarthome.binding.mqtt.internal.TopicSubscribeMultiConnection;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.io.transport.mqtt.MqttService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={ThingHandlerFactory.class, MQTTTopicDiscoveryService.class}, configurationPid="MqttBrokerHandlerFactory")
public class MqttBrokerHandlerFactory
extends BaseThingHandlerFactory
implements MQTTTopicDiscoveryService {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Stream.of(MqttBindingConstants.BRIDGE_TYPE_SYSTEMBROKER, MqttBindingConstants.BRIDGE_TYPE_BROKER).collect(Collectors.toSet());
    protected final Map<MQTTTopicDiscoveryParticipant, TopicSubscribeMultiConnection> subscriber = Collections.synchronizedMap(new WeakHashMap());
    protected final Set<AbstractBrokerHandler> handlers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    @NonNullByDefault(value={})
    private MqttService mqttService;

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    @Reference
    public void setMqttService(MqttService service) {
        this.mqttService = service;
    }

    public void unsetMqttService(MqttService service) {
        this.mqttService = null;
    }

    protected void removeHandler(@NonNull ThingHandler thingHandler) {
        this.handlers.remove(thingHandler);
        this.subscriber.forEach((receiver, multiConnection) -> multiConnection.remove((AbstractBrokerHandler)thingHandler));
    }

    protected void createdHandler(AbstractBrokerHandler handler) {
        this.handlers.add(handler);
        this.subscriber.forEach((receiver, multiConnection) -> multiConnection.add(handler));
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        AbstractBrokerHandler handler;
        if (this.mqttService == null) {
            throw new IllegalStateException("MqttService must be bound, before ThingHandlers can be created");
        }
        if (!(thing instanceof Bridge)) {
            throw new IllegalStateException("A bridge type is expected");
        }
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)MqttBindingConstants.BRIDGE_TYPE_SYSTEMBROKER)) {
            handler = new SystemBrokerHandler((Bridge)thing, this.mqttService);
        } else if (thingTypeUID.equals((Object)MqttBindingConstants.BRIDGE_TYPE_BROKER)) {
            handler = new BrokerHandler((Bridge)thing);
        } else {
            throw new IllegalStateException("Not supported " + thingTypeUID.toString());
        }
        this.createdHandler(handler);
        return handler;
    }

    @Override
    public void subscribe(MQTTTopicDiscoveryParticipant listener, String topic) {
        if (this.subscriber.containsKey(listener)) {
            return;
        }
        TopicSubscribeMultiConnection multiSubscriber = new TopicSubscribeMultiConnection(listener, topic);
        this.handlers.forEach(multiSubscriber::add);
        this.subscriber.put(listener, multiSubscriber);
    }

    @Override
    public void unsubscribe(MQTTTopicDiscoveryParticipant listener) {
        TopicSubscribeMultiConnection multiSubscriber = this.subscriber.remove(listener);
        if (multiSubscriber != null) {
            multiSubscriber.stop();
        }
    }
}

