/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal.ssl;

import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinMessageDigest;
import org.eclipse.smarthome.binding.mqtt.internal.ssl.PinType;

@NonNullByDefault
public class Pin {
    protected byte @Nullable [] pinData;
    protected @Nullable PinMessageDigest hashDigest;
    protected boolean learning;
    protected final PinType type;

    Pin(PinType type, @Nullable PinMessageDigest hashDigest, boolean learning, byte @Nullable [] pinData) {
        this.type = type;
        this.hashDigest = hashDigest;
        this.learning = learning;
        this.pinData = pinData;
    }

    public PinType getType() {
        return this.type;
    }

    public byte @Nullable [] getHash() {
        return this.pinData;
    }

    public void setLearningMode() {
        this.learning = true;
        this.pinData = null;
    }

    public void setCheckMode(PinMessageDigest pinMessageDigest, byte[] data) {
        this.hashDigest = pinMessageDigest;
        this.learning = false;
        this.pinData = data;
    }

    public static Pin LearningPin(PinType pinType) {
        return new Pin(pinType, null, true, null);
    }

    public static Pin CheckingPin(PinType pinType, PinMessageDigest method, byte[] pinData) {
        return new Pin(pinType, method, false, pinData);
    }

    public boolean isLearning() {
        return this.learning;
    }

    public boolean isEqual(byte[] digestData) {
        if (this.learning) {
            return true;
        }
        return Arrays.equals(this.pinData, digestData);
    }

    public String toString() {
        byte[] pinData = this.pinData;
        PinMessageDigest hashDigest = this.hashDigest;
        if (hashDigest != null && pinData != null) {
            return String.valueOf(this.type.name()) + ":" + hashDigest.toHexString(pinData);
        }
        if (hashDigest != null) {
            return String.valueOf(this.type.name()) + ":" + hashDigest.getMethod();
        }
        return this.type.name();
    }
}

