/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.mqtt.internal.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.util.HexUtils;

@NonNullByDefault
public class PinMessageDigest {
    protected final MessageDigest messageDigest;
    private final String method;

    public PinMessageDigest(String method) throws NoSuchAlgorithmException {
        this.method = method;
        this.messageDigest = MessageDigest.getInstance(method);
    }

    public String toHexString(byte[] digestData) {
        return String.valueOf(this.getMethod()) + ":" + HexUtils.bytesToHex((byte[])digestData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] digest(byte[] origData) {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            return this.messageDigest.digest(origData);
        }
    }

    public String getMethod() {
        return this.method;
    }
}

