/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal;

import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Temperature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class Util {
    public static State calculateAbsoluteHumidity(QuantityType<Temperature> temperature, QuantityType<Dimensionless> relativeHumidity) {
        Double theta = temperature.toUnit(SIUnits.CELSIUS).doubleValue();
        Double saturationVaporPressure = 611.2 * Math.exp(17.62 * theta / (243.12 + theta));
        Double aH = relativeHumidity.doubleValue() / 100.0 * saturationVaporPressure / (461.52 * (273.15 + theta));
        QuantityType absoluteHumidity = new QuantityType((Number)aH, SmartHomeUnits.KILOGRAM_PER_CUBICMETRE).toUnit("g/m\u00b3");
        if (absoluteHumidity != null) {
            return absoluteHumidity;
        }
        throw new IllegalArgumentException("could not change unit");
    }

    public static State calculateDewpoint(QuantityType<Temperature> temperature, QuantityType<Dimensionless> relativeHumidity) {
        Double theta = temperature.toUnit(SIUnits.CELSIUS).doubleValue();
        Double rH = relativeHumidity.doubleValue() / 100.0;
        Double dP = 243.12 * ((17.62 * theta / (243.12 + theta) + Math.log(rH)) / (4283.7744 / (243.12 + theta) - Math.log(rH)));
        QuantityType dewPoint = new QuantityType((Number)dP, SIUnits.CELSIUS);
        return dewPoint;
    }
}

