/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Temperature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.Util;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DS1923
extends AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(DS1923.class);
    private final OwDeviceParameterMap temperatureParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature"));
        }
    };
    private final OwDeviceParameterMap humidityParameterR = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/humidity"));
        }
    };

    public DS1923(SensorId sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() throws OwException {
        Thing thing = this.callback.getThing();
        Channel temperatureChannel = thing.getChannel("temperature");
        if (temperatureChannel == null) {
            throw new OwException("temperature not found");
        }
        this.temperatureParameter.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature"));
        Channel humidityChannel = thing.getChannel("humidity");
        if (humidityChannel != null) {
            this.humidityParameterR.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/humidity"));
        }
        this.isConfigured = true;
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
        if (this.isConfigured.booleanValue() && (this.enabledChannels.contains("temperature") || this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint"))) {
            QuantityType temperature = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.temperatureParameter)), SIUnits.CELSIUS);
            this.logger.trace("read temperature {} from {}", (Object)temperature, (Object)this.sensorId);
            this.callback.postUpdate("temperature", (State)temperature);
            if (this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint")) {
                QuantityType humidity = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.humidityParameterR)), SmartHomeUnits.PERCENT);
                this.logger.trace("read humidity {} from {}", (Object)humidity, (Object)this.sensorId);
                if (this.enabledChannels.contains("humidity")) {
                    this.callback.postUpdate("humidity", (State)humidity);
                }
                if (this.enabledChannels.contains("absolutehumidity")) {
                    this.callback.postUpdate("absolutehumidity", Util.calculateAbsoluteHumidity((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                }
                if (this.enabledChannels.contains("dewpoint")) {
                    this.callback.postUpdate("dewpoint", Util.calculateDewpoint((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                }
            }
        }
    }
}

