/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.DigitalIoConfig;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractDigitalOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;

@NonNullByDefault
public class DS2408
extends AbstractDigitalOwDevice {
    public DS2408(SensorId sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() throws OwException {
        this.ioConfig.clear();
        int i = 0;
        while (i < 8) {
            OwDeviceParameterMap inParam = new OwDeviceParameterMap();
            OwDeviceParameterMap outParam = new OwDeviceParameterMap();
            inParam.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("uncached/", String.format("/sensed.%d", i)));
            outParam.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter(String.format("/PIO.%d", i)));
            this.ioConfig.add(new DigitalIoConfig(this.callback.getThing(), i, inParam, outParam));
            ++i;
        }
        this.fullInParam.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("uncached/", "/sensed.BYTE"));
        this.fullOutParam.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/PIO.BYTE"));
        super.configureChannels();
    }
}

