/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Temperature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.Util;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DS2438
extends AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(DS2438.class);
    private LightSensorType lightSensorType = LightSensorType.ELABNET_V1;
    private CurrentSensorType currentSensorType = CurrentSensorType.INTERNAL;
    private final OwDeviceParameterMap temperatureParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature"));
        }
    };
    private final OwDeviceParameterMap humidityParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/humidity"));
        }
    };
    private final OwDeviceParameterMap voltageParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/VAD"));
        }
    };
    private final OwDeviceParameterMap currentParamater = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/vis"));
        }
    };
    private final OwDeviceParameterMap supplyVoltageParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/VDD"));
        }
    };

    public DS2438(SensorId sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() {
        Thing thing = this.callback.getThing();
        Channel humidityChannel = thing.getChannel("humidity");
        if (humidityChannel != null) {
            Configuration channelConfiguration = humidityChannel.getConfiguration();
            if (channelConfiguration.get("humiditytype") != null) {
                this.humidityParameter.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter((String)channelConfiguration.get("humiditytype")));
            } else {
                this.humidityParameter.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/humidity"));
            }
        }
        this.isConfigured = true;
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
        if (this.isConfigured.booleanValue()) {
            double Vcc = 5.0;
            if (this.enabledChannels.contains("temperature") || this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint")) {
                QuantityType temperature = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.temperatureParameter)), SIUnits.CELSIUS);
                this.logger.trace("read temperature {} from {}", (Object)temperature, (Object)this.sensorId);
                if (this.enabledChannels.contains("temperature")) {
                    this.callback.postUpdate("temperature", (State)temperature);
                }
                if (this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint")) {
                    QuantityType humidity = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.humidityParameter)), SmartHomeUnits.PERCENT);
                    this.logger.trace("read humidity {} from {}", (Object)humidity, (Object)this.sensorId);
                    if (this.enabledChannels.contains("humidity")) {
                        this.callback.postUpdate("humidity", (State)humidity);
                    }
                    if (this.enabledChannels.contains("absolutehumidity")) {
                        this.callback.postUpdate("absolutehumidity", Util.calculateAbsoluteHumidity((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                    }
                    if (this.enabledChannels.contains("dewpoint")) {
                        this.callback.postUpdate("dewpoint", Util.calculateDewpoint((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                    }
                }
            }
            if (this.enabledChannels.contains("voltage")) {
                QuantityType voltage = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.voltageParameter)), SmartHomeUnits.VOLT);
                this.logger.trace("read voltage {} from {}", (Object)voltage, (Object)this.sensorId);
                this.callback.postUpdate("voltage", (State)voltage);
            }
            if (this.enabledChannels.contains("current")) {
                State current;
                if (this.currentSensorType == CurrentSensorType.IBUTTONLINK) {
                    current = bridgeHandler.readDecimalType(this.sensorId, this.voltageParameter);
                    if (current instanceof DecimalType) {
                        double currentDouble = ((DecimalType)current).doubleValue();
                        if (currentDouble >= 0.1 || currentDouble <= 3.78) {
                            current = new QuantityType((Number)(currentDouble * 5.163 + 0.483), SmartHomeUnits.AMPERE);
                        }
                        this.callback.postUpdate("current", current);
                    } else {
                        this.callback.postUpdate("current", (State)UnDefType.UNDEF);
                    }
                } else {
                    current = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.currentParamater)), MetricPrefix.MILLI((Unit)SmartHomeUnits.AMPERE));
                    this.callback.postUpdate("current", current);
                }
            }
            if (this.enabledChannels.contains("supplyvoltage")) {
                Vcc = ((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.supplyVoltageParameter)).doubleValue();
                QuantityType supplyVoltage = new QuantityType((Number)Vcc, SmartHomeUnits.VOLT);
                this.callback.postUpdate("supplyvoltage", (State)supplyVoltage);
            }
            if (this.enabledChannels.contains("light")) {
                switch (this.lightSensorType) {
                    case ELABNET_V2: {
                        State light = bridgeHandler.readDecimalType(this.sensorId, this.currentParamater);
                        if (!(light instanceof DecimalType)) break;
                        light = new QuantityType((Number)Math.round(Math.pow(10.0, ((DecimalType)light).doubleValue() / 47.0 * 1000.0)), SmartHomeUnits.LUX);
                        this.callback.postUpdate("light", light);
                        break;
                    }
                    case ELABNET_V1: {
                        State light = bridgeHandler.readDecimalType(this.sensorId, this.currentParamater);
                        if (!(light instanceof DecimalType)) break;
                        light = new QuantityType((Number)Math.round(Math.exp(1.059 * Math.log(1000000.0 * ((DecimalType)light).doubleValue() / 1597440.0) + 4.518) * 20000.0), SmartHomeUnits.LUX);
                        this.callback.postUpdate("light", light);
                        break;
                    }
                    case IBUTTONLINK: {
                        State light = bridgeHandler.readDecimalType(this.sensorId, this.voltageParameter);
                        if (!(light instanceof DecimalType)) break;
                        light = new QuantityType((Number)Math.pow(10.0, 8.666666666666666 - 6.266666666666667 * (Vcc / ((DecimalType)light).doubleValue())), SmartHomeUnits.LUX);
                        this.callback.postUpdate("light", light);
                    }
                }
            }
        }
    }

    public void setLightSensorType(LightSensorType lightSensorType) {
        this.lightSensorType = lightSensorType;
    }

    public void setCurrentSensorType(CurrentSensorType currentSensorType) {
        this.currentSensorType = currentSensorType;
    }

    public static enum CurrentSensorType {
        INTERNAL,
        IBUTTONLINK;

    }

    public static enum LightSensorType {
        ELABNET_V1,
        ELABNET_V2,
        IBUTTONLINK;

    }
}

