/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.device;

import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Temperature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.Util;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EDS006x
extends AbstractOwDevice {
    private final Logger logger = LoggerFactory.getLogger(EDS006x.class);
    private final OwDeviceParameterMap temperatureParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/temperature"));
        }
    };
    private final OwDeviceParameterMap humidityParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/humidity"));
        }
    };
    private final OwDeviceParameterMap pressureParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/pressure"));
        }
    };
    private final OwDeviceParameterMap lightParameter = new OwDeviceParameterMap(){
        {
            this.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/light"));
        }
    };

    public EDS006x(SensorId sensorId, OwBaseThingHandler callback) {
        super(sensorId, callback);
    }

    @Override
    public void configureChannels() {
        this.isConfigured = false;
    }

    public void configureChannels(OwSensorType sensorType) {
        String sensorTypeName = sensorType.name();
        this.temperatureParameter.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/" + sensorTypeName + "/temperature"));
        this.humidityParameter.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/" + sensorTypeName + "/humidity"));
        this.pressureParameter.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/" + sensorTypeName + "/pressure"));
        this.lightParameter.set(OwBindingConstants.THING_TYPE_OWSERVER, new OwserverDeviceParameter("/" + sensorTypeName + "/light"));
        this.isConfigured = true;
    }

    @Override
    public void refresh(OwBaseBridgeHandler bridgeHandler, Boolean forcedRefresh) throws OwException {
        if (this.isConfigured.booleanValue()) {
            if (this.enabledChannels.contains("temperature") || this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint")) {
                QuantityType temperature = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.temperatureParameter)), SIUnits.CELSIUS);
                this.logger.trace("read temperature {} from {}", (Object)temperature, (Object)this.sensorId);
                if (this.enabledChannels.contains("temperature")) {
                    this.callback.postUpdate("temperature", (State)temperature);
                }
                if (this.enabledChannels.contains("humidity") || this.enabledChannels.contains("absolutehumidity") || this.enabledChannels.contains("dewpoint")) {
                    QuantityType humidity = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.humidityParameter)), SmartHomeUnits.PERCENT);
                    this.logger.trace("read humidity {} from {}", (Object)humidity, (Object)this.sensorId);
                    if (this.enabledChannels.contains("humidity")) {
                        this.callback.postUpdate("humidity", (State)humidity);
                    }
                    if (this.enabledChannels.contains("absolutehumidity")) {
                        this.callback.postUpdate("absolutehumidity", Util.calculateAbsoluteHumidity((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                    }
                    if (this.enabledChannels.contains("dewpoint")) {
                        this.callback.postUpdate("dewpoint", Util.calculateDewpoint((QuantityType<Temperature>)temperature, (QuantityType<Dimensionless>)humidity));
                    }
                }
            }
            if (this.enabledChannels.contains("light")) {
                QuantityType light = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.lightParameter)), SmartHomeUnits.LUX);
                this.logger.trace("read light {} from {}", (Object)light, (Object)this.sensorId);
                this.callback.postUpdate("light", (State)light);
            }
            if (this.enabledChannels.contains("pressure")) {
                QuantityType pressure = new QuantityType((Number)((DecimalType)bridgeHandler.readDecimalType(this.sensorId, this.pressureParameter)), MetricPrefix.HECTO((Unit)SIUnits.PASCAL));
                this.logger.trace("read pressure {} from {}", (Object)pressure, (Object)this.sensorId);
                this.callback.postUpdate("pressure", (State)pressure);
            }
        }
    }
}

