/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.discovery;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.discovery.OwDiscoveryItem;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(OwDiscoveryService.class);
    private final OwBaseBridgeHandler owBridgeHandler;
    Map<SensorId, OwDiscoveryItem> owDiscoveryItems = new HashMap<SensorId, OwDiscoveryItem>();
    Set<SensorId> associatedSensors = new HashSet<SensorId>();
    ThingUID bridgeUID;

    public OwDiscoveryService(OwBaseBridgeHandler owBridgeHandler) {
        super(OwBindingConstants.SUPPORTED_THING_TYPES, 60, false);
        this.owBridgeHandler = owBridgeHandler;
        this.logger.debug("registering discovery service for {}", (Object)owBridgeHandler);
    }

    private void scanDirectory(String baseDirectory) {
        List<SensorId> directoryList;
        this.logger.trace("scanning {} on bridge {}", (Object)baseDirectory, (Object)this.bridgeUID);
        try {
            directoryList = this.owBridgeHandler.getDirectory(baseDirectory);
        }
        catch (OwException owException) {
            this.logger.info("empty directory '{}' for {}", (Object)baseDirectory, (Object)this.bridgeUID);
            return;
        }
        for (SensorId directoryEntry : directoryList) {
            try {
                OwDiscoveryItem owDiscoveryItem = new OwDiscoveryItem(this.owBridgeHandler, directoryEntry);
                if (owDiscoveryItem.getSensorType() == OwSensorType.DS2409) {
                    this.logger.trace("found hub {}, scanning sub-directories", (Object)directoryEntry);
                    this.scanDirectory(String.valueOf(owDiscoveryItem.getSensorId().getFullPath()) + "/main/");
                    this.scanDirectory(String.valueOf(owDiscoveryItem.getSensorId().getFullPath()) + "/aux/");
                    continue;
                }
                this.logger.trace("found sensor {} (type: {})", (Object)directoryEntry, (Object)owDiscoveryItem.getSensorType());
                this.owDiscoveryItems.put(owDiscoveryItem.getSensorId(), owDiscoveryItem);
                this.associatedSensors.addAll(owDiscoveryItem.getAssociatedSensorIds());
            }
            catch (OwException e) {
                this.logger.debug("error while scanning for sensors in directory {} on bridge {}: {}", new Object[]{baseDirectory, this.bridgeUID, e.getMessage()});
            }
        }
    }

    public void startScan() {
        this.bridgeUID = this.owBridgeHandler.getThing().getUID();
        this.scanDirectory("/");
        this.owDiscoveryItems.entrySet().removeIf(s -> this.associatedSensors.contains(s.getKey()));
        for (OwDiscoveryItem owDiscoveryItem : this.owDiscoveryItems.values()) {
            owDiscoveryItem.checkSensorType();
            try {
                ThingTypeUID thingTypeUID = owDiscoveryItem.getThingTypeUID();
                String normalizedId = owDiscoveryItem.getNormalizedSensorId();
                ThingUID thingUID = new ThingUID(thingTypeUID, this.bridgeUID, normalizedId);
                this.logger.debug("created thing UID {} for sensor {}, type {}", new Object[]{thingUID, owDiscoveryItem.getSensorId(), owDiscoveryItem.getSensorType()});
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("modelId", owDiscoveryItem.getSensorType().toString());
                properties.put("vendor", owDiscoveryItem.getVendor());
                properties.put("id", owDiscoveryItem.getSensorId().getFullPath());
                DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withThingType(thingTypeUID).withProperties(properties).withBridge(this.bridgeUID).withLabel(owDiscoveryItem.getLabel()).build();
                this.thingDiscovered(discoveryResult);
            }
            catch (OwException e) {
                this.logger.info("sensor-id {}: {}", (Object)owDiscoveryItem.getSensorId(), (Object)e.getMessage());
            }
        }
    }

    protected synchronized void stopScan() {
        this.removeOlderResults(this.getTimestampOfLastScan());
        super.stopScan();
    }

    public void deactivate() {
        this.removeOlderResults(new Date().getTime());
    }
}

