/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.device.EDS006x;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EDSSensorThingHandler
extends OwBaseThingHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(OwBindingConstants.THING_TYPE_EDS_ENV);
    public static final Set<OwSensorType> SUPPORTED_SENSOR_TYPES = Collections.unmodifiableSet(Stream.of(OwSensorType.EDS0064, OwSensorType.EDS0065, OwSensorType.EDS0066, OwSensorType.EDS0067, OwSensorType.EDS0068).collect(Collectors.toSet()));
    private static final Set<String> REQUIRED_PROPERTIES = Collections.singleton("hwRevision");
    private final Logger logger = LoggerFactory.getLogger(EDSSensorThingHandler.class);

    public EDSSensorThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        super(thing, dynamicStateDescriptionProvider, SUPPORTED_SENSOR_TYPES, REQUIRED_PROPERTIES);
    }

    @Override
    public void initialize() {
        if (!super.configure()) {
            return;
        }
        this.sensors.add(new EDS006x(this.sensorId, this));
        ((EDS006x)this.sensors.get(0)).configureChannels(this.sensorType);
        this.scheduler.execute(() -> this.configureThingChannels());
    }

    private void configureThingChannels() {
        ThingBuilder thingBuilder = this.editThing();
        this.logger.debug("configuring sensors for {}", (Object)this.thing.getLabel());
        try {
            EDS006x sensor = (EDS006x)this.sensors.get(0);
            sensor.configureChannels(this.sensorType);
            switch (this.sensorType) {
                case EDS0064: {
                    sensor.enableChannel("temperature");
                    break;
                }
                case EDS0065: {
                    sensor.enableChannel("temperature");
                    sensor.enableChannel("humidity");
                    sensor.enableChannel("absolutehumidity");
                    sensor.enableChannel("dewpoint");
                    break;
                }
                case EDS0066: {
                    sensor.enableChannel("temperature");
                    sensor.enableChannel("pressure");
                    break;
                }
                case EDS0067: {
                    sensor.enableChannel("temperature");
                    sensor.enableChannel("light");
                    break;
                }
                case EDS0068: {
                    sensor.enableChannel("temperature");
                    sensor.enableChannel("humidity");
                    sensor.enableChannel("absolutehumidity");
                    sensor.enableChannel("dewpoint");
                    sensor.enableChannel("pressure");
                    sensor.enableChannel("light");
                    break;
                }
                default: {
                    throw new OwException("sensor not supported");
                }
            }
        }
        catch (OwException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getMessage());
            return;
        }
        if (this.sensorType == OwSensorType.EDS0065 || this.sensorType == OwSensorType.EDS0068) {
            this.addChannelIfMissing(thingBuilder, "humidity", OwBindingConstants.CHANNEL_TYPE_UID_HUMIDITY);
            this.addChannelIfMissing(thingBuilder, "absolutehumidity", OwBindingConstants.CHANNEL_TYPE_UID_ABSHUMIDITY);
            this.addChannelIfMissing(thingBuilder, "dewpoint", OwBindingConstants.CHANNEL_TYPE_UID_DEWPOINT);
        } else {
            this.removeChannelIfExisting(thingBuilder, "humidity");
            this.removeChannelIfExisting(thingBuilder, "dewpoint");
            this.removeChannelIfExisting(thingBuilder, "absolutehumidity");
        }
        if (this.sensorType == OwSensorType.EDS0066 || this.sensorType == OwSensorType.EDS0068) {
            this.addChannelIfMissing(thingBuilder, "pressure", OwBindingConstants.CHANNEL_TYPE_UID_PRESSURE);
        } else {
            this.removeChannelIfExisting(thingBuilder, "pressure");
        }
        if (this.sensorType == OwSensorType.EDS0067 || this.sensorType == OwSensorType.EDS0068) {
            this.addChannelIfMissing(thingBuilder, "light", OwBindingConstants.CHANNEL_TYPE_UID_LIGHT);
        } else {
            this.removeChannelIfExisting(thingBuilder, "light");
        }
        this.updateThing(thingBuilder.build());
        this.validConfig = true;
        this.updatePresenceStatus((State)UnDefType.UNDEF);
    }

    @Override
    public Map<String, String> updateSensorProperties(OwBaseBridgeHandler bridgeHandler) throws OwException {
        HashMap<String, String> properties = new HashMap<String, String>();
        OwPageBuffer pages = bridgeHandler.readPages(this.sensorId);
        OwSensorType sensorType = OwSensorType.UNKNOWN;
        try {
            sensorType = OwSensorType.valueOf(new String(pages.getPage(0), 0, 7, StandardCharsets.US_ASCII));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (!SUPPORTED_SENSOR_TYPES.contains((Object)sensorType)) {
            throw new OwException("sensorType not supported for EDSSensorThing");
        }
        int fwRevisionLow = pages.getByte(3, 3);
        int fwRevisionHigh = pages.getByte(3, 4);
        String fwRevision = String.format("%d.%d", fwRevisionHigh, fwRevisionLow);
        properties.put("modelId", sensorType.name());
        properties.put("vendor", "Embedded Data Systems");
        properties.put("hwRevision", String.valueOf(fwRevision));
        return properties;
    }
}

