/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseThingHandler;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.binding.BaseBridgeHandler;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class OwBaseBridgeHandler
extends BaseBridgeHandler {
    private final Logger logger = LoggerFactory.getLogger(OwBaseBridgeHandler.class);
    protected boolean refreshable = false;
    protected ScheduledFuture<?> refreshTask = this.scheduler.scheduleWithFixedDelay(() -> this.refresh(), 1L, 1000L, TimeUnit.MILLISECONDS);
    private final Queue<@Nullable Thing> thingPropertiesUpdateQueue = new ConcurrentLinkedQueue<Thing>();

    public OwBaseBridgeHandler(Bridge bridge) {
        super(bridge);
    }

    private void refresh() {
        if (this.refreshable) {
            OwBaseThingHandler owHandler;
            long now = System.currentTimeMillis();
            List thingList = this.getThing().getThings();
            int thingCount = thingList.size();
            Iterator childListIterator = thingList.iterator();
            this.logger.trace("refreshTask starts at {}, {} childs", (Object)now, (Object)thingCount);
            while (childListIterator.hasNext() && this.refreshable) {
                Thing owThing = (Thing)childListIterator.next();
                this.logger.trace("refresh: getting handler for {} ({} to go)", (Object)owThing.getUID(), (Object)thingCount);
                owHandler = (OwBaseThingHandler)owThing.getHandler();
                if (owHandler != null) {
                    if (owHandler.isRefreshable()) {
                        this.logger.trace("{} initialized, refreshing", (Object)owThing.getUID());
                        owHandler.refresh(this, now);
                    } else {
                        this.logger.trace("{} not initialized, skipping refresh", (Object)owThing.getUID());
                    }
                } else {
                    this.logger.debug("{} handler missing", (Object)owThing.getUID());
                }
                --thingCount;
            }
            this.refreshBridgeChannels(now);
            Thing updateThing = this.thingPropertiesUpdateQueue.poll();
            if (updateThing != null) {
                this.logger.trace("update: getting handler for {} ({} total in list)", (Object)updateThing.getUID(), (Object)this.thingPropertiesUpdateQueue.size());
                owHandler = (OwBaseThingHandler)updateThing.getHandler();
                if (owHandler != null) {
                    try {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.putAll(updateThing.getProperties());
                        properties.putAll(owHandler.updateSensorProperties(this));
                        updateThing.setProperties(properties);
                        owHandler.initialize();
                        this.logger.debug("{} sucessfully updated properties, removing from property update list", (Object)updateThing.getUID());
                    }
                    catch (OwException e) {
                        this.thingPropertiesUpdateQueue.add(updateThing);
                        this.logger.debug("updating thing properties for {} failed: {}, adding to end of list", (Object)updateThing.getUID(), (Object)e.getMessage());
                    }
                } else {
                    this.logger.debug("{} is missing handler, removing from property update list", (Object)updateThing.getUID());
                }
            }
        }
    }

    public void initialize() {
        if (this.refreshTask.isCancelled()) {
            this.refreshTask = this.scheduler.scheduleWithFixedDelay(() -> this.refresh(), 1L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public void dispose() {
        this.refreshable = false;
        if (!this.refreshTask.isCancelled()) {
            this.refreshTask.cancel(false);
        }
    }

    public void scheduleForPropertiesUpdate(Thing thing) {
        this.thingPropertiesUpdateQueue.add(thing);
    }

    public abstract List<SensorId> getDirectory(String var1) throws OwException;

    public abstract State checkPresence(SensorId var1) throws OwException;

    public abstract OwSensorType getType(SensorId var1) throws OwException;

    public abstract OwPageBuffer readPages(SensorId var1) throws OwException;

    public abstract State readDecimalType(SensorId var1, OwDeviceParameterMap var2) throws OwException;

    public BitSet readBitSet(SensorId sensorId, OwDeviceParameterMap parameter) throws OwException {
        return BitSet.valueOf(new long[]{((DecimalType)this.readDecimalType(sensorId, parameter)).longValue()});
    }

    public abstract List<State> readDecimalTypeArray(SensorId var1, OwDeviceParameterMap var2) throws OwException;

    public abstract String readString(SensorId var1, OwDeviceParameterMap var2) throws OwException;

    public abstract void writeDecimalType(SensorId var1, OwDeviceParameterMap var2, DecimalType var3) throws OwException;

    public void writeBitSet(SensorId sensorId, OwDeviceParameterMap parameter, BitSet value) throws OwException {
        this.writeDecimalType(sensorId, parameter, new DecimalType(value.toLongArray()[0]));
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public void refreshBridgeChannels(long now) {
    }
}

