/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwDynamicStateDescriptionProvider;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.AbstractOwDevice;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class OwBaseThingHandler
extends BaseThingHandler {
    private final Logger logger = LoggerFactory.getLogger(OwBaseThingHandler.class);
    protected static final int PROPERTY_UPDATE_INTERVAL = 5000;
    protected static final int PROPERTY_UPDATE_MAX_RETRY = 5;
    private static final Set<String> REQUIRED_PROPERTIES = Collections.unmodifiableSet(Stream.of("modelId", "vendor").collect(Collectors.toSet()));
    protected List<String> requiredProperties = new ArrayList<String>(REQUIRED_PROPERTIES);
    protected Set<OwSensorType> supportedSensorTypes;
    protected final List<AbstractOwDevice> sensors = new ArrayList<AbstractOwDevice>();
    @NonNullByDefault(value={})
    protected SensorId sensorId;
    @NonNullByDefault(value={})
    protected OwSensorType sensorType;
    protected long lastRefresh = 0L;
    protected long refreshInterval = 300000L;
    protected boolean validConfig = false;
    protected boolean showPresence = false;
    protected OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider;
    protected @Nullable ScheduledFuture<?> updateTask;

    public OwBaseThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider, Set<OwSensorType> supportedSensorTypes) {
        super(thing);
        this.dynamicStateDescriptionProvider = dynamicStateDescriptionProvider;
        this.supportedSensorTypes = supportedSensorTypes;
    }

    public OwBaseThingHandler(Thing thing, OwDynamicStateDescriptionProvider dynamicStateDescriptionProvider, Set<OwSensorType> supportedSensorTypes, Set<String> requiredProperties) {
        super(thing);
        this.dynamicStateDescriptionProvider = dynamicStateDescriptionProvider;
        this.supportedSensorTypes = supportedSensorTypes;
        this.requiredProperties.addAll(requiredProperties);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (command instanceof RefreshType) {
            this.lastRefresh = 0L;
            this.logger.trace("scheduled {} for refresh", (Object)this.thing.getUID());
        }
    }

    public void initialize() {
        this.configure();
    }

    protected boolean configure() {
        Configuration configuration = this.getConfig();
        Map properties = this.thing.getProperties();
        if (this.getBridge() == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "bridge missing");
            return false;
        }
        this.sensors.clear();
        if (configuration.get("id") != null) {
            String sensorId = (String)configuration.get("id");
            try {
                this.sensorId = new SensorId(sensorId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "sensor id format mismatch");
                return false;
            }
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "sensor id missing");
            return false;
        }
        this.refreshInterval = configuration.get("refresh") != null ? (long)(((BigDecimal)configuration.get("refresh")).intValue() * 1000) : 300000L;
        if (this.thing.getChannel("present") != null) {
            this.showPresence = true;
        }
        for (String property : this.requiredProperties) {
            if (properties.containsKey(property)) continue;
            this.updateSensorProperties();
            return false;
        }
        this.sensorType = OwSensorType.valueOf((String)properties.get("modelId"));
        if (!this.supportedSensorTypes.contains((Object)this.sensorType)) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "sensor type not supported by this thing type");
            return false;
        }
        this.lastRefresh = 0L;
        return true;
    }

    public boolean isRefreshable() {
        return super.isInitialized() && this.thing.getStatusInfo().getStatusDetail() != ThingStatusDetail.CONFIGURATION_ERROR && this.thing.getStatusInfo().getStatusDetail() != ThingStatusDetail.BRIDGE_OFFLINE;
    }

    public void refresh(OwBaseBridgeHandler bridgeHandler, long now) {
        try {
            Boolean forcedRefresh = this.lastRefresh == 0L;
            if (now >= this.lastRefresh + this.refreshInterval) {
                this.logger.trace("refreshing {}", (Object)this.thing.getUID());
                this.lastRefresh = now;
                if (!this.sensors.get(0).checkPresence(bridgeHandler).booleanValue()) {
                    this.logger.trace("sensor not present");
                    return;
                }
                int i = 0;
                while (i < this.sensors.size()) {
                    this.logger.trace("refreshing sensor {} ({})", (Object)i, (Object)this.sensors.get(i).getSensorId());
                    this.sensors.get(i).refresh(bridgeHandler, forcedRefresh);
                    ++i;
                }
            }
        }
        catch (OwException e) {
            this.logger.debug("{}: refresh exception {}", (Object)this.thing.getUID(), (Object)e.getMessage());
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "refresh exception");
        }
    }

    public void updatePresenceStatus(State presentState) {
        if (OnOffType.ON.equals((Object)presentState)) {
            this.updateStatus(ThingStatus.ONLINE);
            if (this.showPresence) {
                this.updateState("present", (State)OnOffType.ON);
            }
        } else if (OnOffType.OFF.equals((Object)presentState)) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "slave missing");
            if (this.showPresence) {
                this.updateState("present", (State)OnOffType.OFF);
            }
        } else {
            this.updateStatus(ThingStatus.UNKNOWN);
            if (this.showPresence) {
                this.updateState("present", (State)UnDefType.UNDEF);
            }
        }
    }

    public void postUpdate(String channelId, State state) {
        if (this.thing.getChannel(channelId) != null) {
            this.updateState(channelId, state);
        } else {
            this.logger.warn("{} missing channel {} when posting update {}", new Object[]{this.thing.getUID(), channelId, state});
        }
    }

    public void bridgeStatusChanged(ThingStatusInfo bridgeStatusInfo) {
        if (bridgeStatusInfo.getStatus() == ThingStatus.ONLINE && this.getThing().getStatusInfo().getStatusDetail() == ThingStatusDetail.BRIDGE_OFFLINE) {
            if (this.validConfig) {
                this.updatePresenceStatus((State)UnDefType.UNDEF);
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR);
            }
        } else if (bridgeStatusInfo.getStatus() == ThingStatus.OFFLINE) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE);
        }
    }

    public void dispose() {
        this.dynamicStateDescriptionProvider.removeDescriptionsForThing(this.thing.getUID());
        super.dispose();
    }

    protected void updateSensorProperties() {
        Bridge bridge = this.getBridge();
        if (bridge == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "bridge not found");
            return;
        }
        OwBaseBridgeHandler bridgeHandler = (OwBaseBridgeHandler)bridge.getHandler();
        if (bridgeHandler == null) {
            this.logger.debug("bridgehandler for {} not available for scheduling property update, retrying in 5s", (Object)this.thing.getUID());
            this.scheduler.schedule(() -> this.updateSensorProperties(), 5000L, TimeUnit.MILLISECONDS);
            return;
        }
        bridgeHandler.scheduleForPropertiesUpdate(this.thing);
    }

    public Map<String, String> updateSensorProperties(OwBaseBridgeHandler bridgeHandler) throws OwException {
        HashMap<String, String> properties = new HashMap<String, String>();
        OwSensorType sensorType = bridgeHandler.getType(this.sensorId);
        properties.put("modelId", sensorType.toString());
        properties.put("vendor", "Dallas/Maxim");
        this.logger.trace("updated modelid/vendor to {} / {}", (Object)sensorType.name(), (Object)"Dallas/Maxim");
        return properties;
    }

    public @Nullable OwDynamicStateDescriptionProvider getDynamicStateDescriptionProvider() {
        return this.dynamicStateDescriptionProvider;
    }

    protected void removeChannelIfExisting(ThingBuilder thingBuilder, String channelId) {
        if (this.thing.getChannel(channelId) != null) {
            thingBuilder.withoutChannel(new ChannelUID(this.thing.getUID(), channelId));
        }
    }

    protected Channel addChannelIfMissing(ThingBuilder thingBuilder, String channelId, ChannelTypeUID channelTypeUID) {
        Channel channel = this.thing.getChannel(channelId);
        if (channel == null) {
            channel = ChannelBuilder.create((ChannelUID)new ChannelUID(this.thing.getUID(), channelId), (String)OwBindingConstants.ACCEPTED_ITEM_TYPES_MAP.get(channelId)).withType(channelTypeUID).build();
            thingBuilder.withChannel(channel);
        }
        return channel;
    }

    protected Channel addChannelIfMissing(ThingBuilder thingBuilder, String channelId, ChannelTypeUID channelTypeUID, String label) {
        Channel channel = this.thing.getChannel(channelId);
        if (channel == null) {
            channel = ChannelBuilder.create((ChannelUID)new ChannelUID(this.thing.getUID(), channelId), (String)OwBindingConstants.ACCEPTED_ITEM_TYPES_MAP.get(channelId)).withType(channelTypeUID).withLabel(label).build();
            thingBuilder.withChannel(channel);
        }
        return channel;
    }

    protected Channel addChannelIfMissing(ThingBuilder thingBuilder, String channelId, ChannelTypeUID channelTypeUID, Configuration configuration) {
        Channel channel = this.thing.getChannel(channelId);
        if (channel == null) {
            channel = ChannelBuilder.create((ChannelUID)new ChannelUID(this.thing.getUID(), channelId), (String)OwBindingConstants.ACCEPTED_ITEM_TYPES_MAP.get(channelId)).withType(channelTypeUID).withConfiguration(configuration).build();
            thingBuilder.withChannel(channel);
        }
        return channel;
    }
}

