/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwBindingConstants;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.device.OwDeviceParameterMap;
import org.eclipse.smarthome.binding.onewire.internal.device.OwSensorType;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwBaseBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwfsDirectChannelConfig;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverConnection;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverConnectionState;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverDeviceParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OwserverBridgeHandler
extends OwBaseBridgeHandler {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Collections.singleton(OwBindingConstants.THING_TYPE_OWSERVER);
    private final Logger logger = LoggerFactory.getLogger(OwserverBridgeHandler.class);
    private static final int RECONNECT_AFTER_FAIL_TIME = 5000;
    private final OwserverConnection owserverConnection;
    private final List<OwfsDirectChannelConfig> channelConfigs = new ArrayList<OwfsDirectChannelConfig>();

    public OwserverBridgeHandler(Bridge bridge) {
        super(bridge);
        this.owserverConnection = new OwserverConnection(this);
    }

    public OwserverBridgeHandler(Bridge bridge, OwserverConnection owserverConnection) {
        super(bridge);
        this.owserverConnection = owserverConnection;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    @Override
    public void initialize() {
        Configuration configuration = this.getConfig();
        if (configuration.get("network-address") != null) {
            this.owserverConnection.setHost((String)configuration.get("network-address"));
        }
        if (configuration.get("port") != null) {
            this.owserverConnection.setPort(((BigDecimal)configuration.get("port")).intValue());
        }
        for (Channel channel : this.thing.getChannels()) {
            if (!OwBindingConstants.CHANNEL_TYPE_UID_OWFS_NUMBER.equals((Object)channel.getChannelTypeUID()) && !OwBindingConstants.CHANNEL_TYPE_UID_OWFS_STRING.equals((Object)channel.getChannelTypeUID())) continue;
            OwfsDirectChannelConfig channelConfig = (OwfsDirectChannelConfig)channel.getConfiguration().as(OwfsDirectChannelConfig.class);
            if (channelConfig.initialize(channel.getUID(), channel.getAcceptedItemType())) {
                this.channelConfigs.add(channelConfig);
                continue;
            }
            this.logger.info("configuration mismatch: {}", (Object)channelConfig);
        }
        this.updateStatus(ThingStatus.UNKNOWN);
        this.scheduler.execute(() -> this.owserverConnection.start());
        super.initialize();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.owserverConnection.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SensorId> getDirectory(String basePath) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.getDirectory(basePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State checkPresence(SensorId sensorId) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.checkPresence(sensorId.getFullPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OwSensorType getType(SensorId sensorId) throws OwException {
        OwSensorType sensorType = OwSensorType.UNKNOWN;
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            try {
                sensorType = OwSensorType.valueOf(this.owserverConnection.readString(sensorId + "/type"));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return sensorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State readDecimalType(SensorId sensorId, OwDeviceParameterMap parameter) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readDecimalType(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(sensorId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<State> readDecimalTypeArray(SensorId sensorId, OwDeviceParameterMap parameter) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readDecimalTypeArray(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(sensorId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OwPageBuffer readPages(SensorId sensorId) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readPages(sensorId.getFullPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(SensorId sensorId, OwDeviceParameterMap parameter) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            return this.owserverConnection.readString(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(sensorId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDecimalType(SensorId sensorId, OwDeviceParameterMap parameter, DecimalType value) throws OwException {
        OwserverConnection owserverConnection = this.owserverConnection;
        synchronized (owserverConnection) {
            this.owserverConnection.writeDecimalType(((OwserverDeviceParameter)parameter.get(OwBindingConstants.THING_TYPE_OWSERVER)).getPath(sensorId), value);
        }
    }

    public void reportConnectionState(OwserverConnectionState connectionState) {
        switch (connectionState) {
            case FAILED: {
                this.refreshable = false;
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
                this.scheduler.schedule(() -> this.owserverConnection.start(), 5000L, TimeUnit.MILLISECONDS);
                break;
            }
            case STOPPED: {
                this.refreshable = false;
                break;
            }
            case OPENED: 
            case CLOSED: {
                this.refreshable = true;
                this.updateStatus(ThingStatus.ONLINE, ThingStatusDetail.NONE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshBridgeChannels(long now) {
        for (OwfsDirectChannelConfig channelConfig : this.channelConfigs) {
            if (now <= channelConfig.lastRefresh + (long)channelConfig.refreshCycle) continue;
            try {
                StringType value;
                OwserverConnection owserverConnection = this.owserverConnection;
                synchronized (owserverConnection) {
                    if (channelConfig.acceptedItemType.equals("String")) {
                        value = new StringType(this.owserverConnection.readString(channelConfig.path));
                    } else if (channelConfig.acceptedItemType.equals("Number")) {
                        value = this.owserverConnection.readDecimalType(channelConfig.path);
                    } else {
                        this.logger.debug("mismatched configuration, itemType unknown for channel {}", (Object)channelConfig.channelUID);
                        continue;
                    }
                }
                this.updateState(channelConfig.channelUID, (State)value);
                this.logger.trace("updated {} to {}", (Object)channelConfig.channelUID, (Object)value);
                channelConfig.lastRefresh = now;
            }
            catch (OwException e) {
                this.logger.debug("could not read direct channel {}: {}", (Object)channelConfig.channelUID, (Object)e.getMessage());
            }
        }
    }
}

