/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.owserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.SensorId;
import org.eclipse.smarthome.binding.onewire.internal.handler.OwserverBridgeHandler;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverConnectionState;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverControlFlag;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverMessageType;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverPacket;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverPacketType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OwserverConnection {
    public static final int DEFAULT_PORT = 4304;
    public static final int KEEPALIVE_INTERVAL = 1000;
    private static final int CONNECTION_MAX_RETRY = 5;
    private final Logger logger = LoggerFactory.getLogger(OwserverConnection.class);
    private final OwserverBridgeHandler thingHandlerCallback;
    private String owserverAddress = "";
    private int owserverPort = 4304;
    private @Nullable Socket owserverSocket = null;
    private @Nullable DataInputStream owserverInputStream = null;
    private @Nullable DataOutputStream owserverOutputStream = null;
    private OwserverConnectionState owserverConnectionState = OwserverConnectionState.STOPPED;
    private int connectionErrorCounter = 0;

    public OwserverConnection(OwserverBridgeHandler thingHandlerCallback) {
        this.thingHandlerCallback = thingHandlerCallback;
    }

    public void setHost(String address) {
        this.owserverAddress = address;
        if (this.owserverConnectionState != OwserverConnectionState.STOPPED) {
            this.close();
        }
    }

    public void setPort(int port) {
        this.owserverPort = port;
        if (this.owserverConnectionState != OwserverConnectionState.STOPPED) {
            this.close();
        }
    }

    public void start() {
        this.connectionErrorCounter = 0;
        this.owserverConnectionState = OwserverConnectionState.CLOSED;
        boolean success = false;
        while (!(success = this.open()) && this.owserverConnectionState != OwserverConnectionState.FAILED) {
        }
    }

    public void stop() {
        this.close();
        this.owserverConnectionState = OwserverConnectionState.STOPPED;
        this.thingHandlerCallback.reportConnectionState(this.owserverConnectionState);
    }

    public List<SensorId> getDirectory(String basePath) throws OwException {
        OwserverPacket requestPacket = new OwserverPacket(OwserverMessageType.DIRALL, basePath, new OwserverControlFlag[0]);
        OwserverPacket returnPacket = this.request(requestPacket);
        if (returnPacket.getReturnCode() != -1 && returnPacket.hasPayload()) {
            this.connectionErrorCounter = 0;
            return Arrays.stream(returnPacket.getPayloadString().split(",")).map(s -> {
                try {
                    return new SensorId((String)s);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }).filter(s -> s != null).collect(Collectors.toList());
        }
        throw new OwException("invalid of empty packet");
    }

    public State checkPresence(String path) throws OwException {
        OnOffType returnValue = OnOffType.OFF;
        try {
            OwserverPacket requestPacket = new OwserverPacket(OwserverMessageType.PRESENT, path, OwserverControlFlag.UNCACHED);
            OwserverPacket returnPacket = this.request(requestPacket);
            if (returnPacket.getReturnCode() == 0) {
                returnValue = OnOffType.ON;
            }
        }
        catch (OwException owException) {
            returnValue = OnOffType.OFF;
        }
        this.logger.trace("presence {} : {}", (Object)path, (Object)returnValue);
        return returnValue;
    }

    public State readDecimalType(String path) throws OwException {
        UnDefType returnState = UnDefType.UNDEF;
        OwserverPacket requestPacket = new OwserverPacket(OwserverMessageType.READ, path, new OwserverControlFlag[0]);
        OwserverPacket returnPacket = this.request(requestPacket);
        if (returnPacket.getReturnCode() == -1 || !returnPacket.hasPayload()) {
            throw new OwException("invalid or empty packet");
        }
        returnState = DecimalType.valueOf((String)returnPacket.getPayloadString().trim());
        return returnState;
    }

    public List<State> readDecimalTypeArray(String path) throws OwException {
        ArrayList<State> returnList = new ArrayList<State>();
        OwserverPacket requestPacket = new OwserverPacket(OwserverMessageType.READ, path, new OwserverControlFlag[0]);
        OwserverPacket returnPacket = this.request(requestPacket);
        if (returnPacket.getReturnCode() == -1 || !returnPacket.hasPayload()) {
            throw new OwException("invalid or empty packet");
        }
        Arrays.stream(returnPacket.getPayloadString().split(",")).forEach(v -> {
            boolean bl = returnList.add((State)DecimalType.valueOf((String)v.trim()));
        });
        return returnList;
    }

    public String readString(String path) throws OwException {
        OwserverPacket requestPacket = new OwserverPacket(OwserverMessageType.READ, path, new OwserverControlFlag[0]);
        OwserverPacket returnPacket = this.request(requestPacket);
        if (returnPacket.getReturnCode() != -1 && returnPacket.hasPayload()) {
            return returnPacket.getPayloadString().trim();
        }
        throw new OwException("invalid or empty packet");
    }

    public OwPageBuffer readPages(String path) throws OwException {
        OwserverPacket requestPacket = new OwserverPacket(OwserverMessageType.READ, String.valueOf(path) + "/pages/page.ALL", new OwserverControlFlag[0]);
        OwserverPacket returnPacket = this.request(requestPacket);
        if (returnPacket.getReturnCode() != -1 && returnPacket.hasPayload()) {
            return returnPacket.getPayload();
        }
        throw new OwException("invalid or empty packet");
    }

    public void writeDecimalType(String path, DecimalType value) throws OwException {
        OwserverPacket requestPacket = new OwserverPacket(OwserverMessageType.WRITE, path, new OwserverControlFlag[0]);
        requestPacket.appendPayload(String.valueOf(value));
        OwserverPacket returnPacket = this.request(requestPacket);
        this.logger.trace("wrote: {}, got: {} ", (Object)requestPacket, (Object)returnPacket);
    }

    private OwserverPacket request(OwserverPacket requestPacket) throws OwException {
        OwserverPacket returnPacket = new OwserverPacket(OwserverPacketType.RETURN);
        boolean payloadExpected = requestPacket.getMessageType() != OwserverMessageType.WRITE;
        try {
            this.write(requestPacket);
            while ((returnPacket = requestPacket.getMessageType() == OwserverMessageType.PRESENT || requestPacket.getMessageType() == OwserverMessageType.NOP ? this.read(true) : this.read(false)).isPingPacket() || returnPacket.hasPayload() != payloadExpected) {
            }
        }
        catch (OwException e) {
            this.logger.debug("failed requesting {}->{} [{}]", new Object[]{requestPacket, returnPacket, e.getMessage()});
            throw e;
        }
        if (!returnPacket.hasControlFlag(OwserverControlFlag.PERSISTENCE)) {
            this.logger.trace("closing connection because persistence was denied");
            this.close();
        }
        this.connectionErrorCounter = 0;
        return returnPacket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean open() {
        try {
            if (this.owserverConnectionState == OwserverConnectionState.CLOSED) {
                this.owserverSocket = new Socket(this.owserverAddress, this.owserverPort);
                this.owserverSocket.setSoTimeout(3000);
                if (this.owserverSocket == null) {
                    this.closeOnError();
                    return false;
                }
                this.owserverInputStream = new DataInputStream(this.owserverSocket.getInputStream());
                if (this.owserverInputStream == null) {
                    this.logger.warn("could not get input stream after opening connection");
                    this.closeOnError();
                    return false;
                }
                if (this.owserverSocket == null) {
                    this.closeOnError();
                    return false;
                }
                this.owserverOutputStream = new DataOutputStream(this.owserverSocket.getOutputStream());
                if (this.owserverOutputStream == null) {
                    this.logger.warn("could not get output stream after opening connection");
                    this.closeOnError();
                    return false;
                }
                this.owserverConnectionState = OwserverConnectionState.OPENED;
                this.thingHandlerCallback.reportConnectionState(this.owserverConnectionState);
                this.logger.debug("opened OwServerConnection to {}:{}", (Object)this.owserverAddress, (Object)this.owserverPort);
                return true;
            }
            if (this.owserverConnectionState != OwserverConnectionState.OPENED) {
                return false;
            }
            this.logger.trace("owServerConnection already open, skipping input buffer");
            do {
                if (this.owserverInputStream != null) continue;
                this.logger.debug("input stream not available on skipping");
                this.closeOnError();
                return false;
            } while (this.owserverInputStream.skip(this.owserverInputStream.available()) != 0L);
            return true;
        }
        catch (IOException e) {
            this.logger.debug("could not open owServerConnection to {}:{}: {}", new Object[]{this.owserverAddress, this.owserverPort, e.getMessage()});
            this.closeOnError();
            return false;
        }
    }

    private void close() {
        if (this.owserverSocket != null) {
            try {
                this.owserverSocket.close();
            }
            catch (IOException e) {
                this.owserverConnectionState = OwserverConnectionState.FAILED;
                this.logger.warn("could not close connection: {}", (Object)e.getMessage());
            }
        }
        this.owserverSocket = null;
        this.owserverInputStream = null;
        this.owserverOutputStream = null;
        this.logger.debug("closed connection");
        this.owserverConnectionState = OwserverConnectionState.CLOSED;
        this.thingHandlerCallback.reportConnectionState(this.owserverConnectionState);
    }

    private void checkConnection() {
        try {
            int pid = ((DecimalType)this.readDecimalType("/system/process/pid")).intValue();
            this.logger.debug("read pid {} -> connection still alive", (Object)pid);
            return;
        }
        catch (OwException owException) {
            this.closeOnError();
            return;
        }
    }

    private void closeOnError() {
        ++this.connectionErrorCounter;
        this.close();
        if (this.connectionErrorCounter > 5) {
            this.owserverConnectionState = OwserverConnectionState.FAILED;
            this.thingHandlerCallback.reportConnectionState(this.owserverConnectionState);
        }
    }

    private void write(OwserverPacket requestPacket) throws OwException {
        block5: {
            try {
                if (this.open()) {
                    requestPacket.setControlFlags(OwserverControlFlag.PERSISTENCE);
                    if (this.owserverOutputStream != null) {
                        this.owserverOutputStream.write(requestPacket.toBytes());
                        this.logger.trace("wrote: {}", (Object)requestPacket);
                    } else {
                        this.logger.debug("output stream not available on write");
                        this.closeOnError();
                    }
                    break block5;
                }
                throw new OwException("I/O error: could not open connection to send request packet");
            }
            catch (IOException e) {
                this.closeOnError();
                this.logger.debug("couldn't send {}, {}", (Object)requestPacket, (Object)e.getMessage());
                throw new OwException("I/O Error: exception while sending request packet - " + e.getMessage());
            }
        }
    }

    private OwserverPacket read(boolean noTimeoutException) throws OwException {
        OwserverPacket returnPacket = new OwserverPacket(OwserverPacketType.RETURN);
        try {
            if (this.owserverInputStream != null) {
                DataInputStream inputStream = this.owserverInputStream;
                returnPacket = new OwserverPacket(inputStream, OwserverPacketType.RETURN);
                this.logger.trace("read: {}", (Object)returnPacket);
            } else {
                this.logger.debug("input stream not available on read");
                this.closeOnError();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (OwException e) {
            this.checkConnection();
            throw e;
        }
        catch (IOException e) {
            if (e.getMessage().equals("Read timed out") && noTimeoutException) {
                this.logger.trace("timeout - setting error code to -1");
                returnPacket.setPayload("timeout");
                returnPacket.setReturnCode(-1);
            }
            this.checkConnection();
            throw new OwException("I/O error: exception while reading packet - " + e.getMessage());
        }
        return returnPacket;
    }
}

