/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.onewire.internal.owserver;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.onewire.internal.OwException;
import org.eclipse.smarthome.binding.onewire.internal.OwPageBuffer;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverControlFlag;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverMessageType;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverPacketType;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverPressureScale;
import org.eclipse.smarthome.binding.onewire.internal.owserver.OwserverTemperatureScale;

@NonNullByDefault
public class OwserverPacket {
    public static final int PROTOCOL_VERSION = 0;
    public static final int HEADER_SIZE = 24;
    protected int payloadLength = 0;
    protected final OwserverPacketType packetType;
    protected int protocolVersion = 0;
    protected int controlFlags;
    protected int packetCode = 0;
    protected int packetSize = 0;
    protected int payloadOffset = 0;
    protected byte[] payload = new byte[0];

    public OwserverPacket(OwserverPacketType packetType) {
        this.packetType = packetType;
        this.setControlFlags(OwserverControlFlag.OWNET, OwserverControlFlag.DEVICE_DISPLAY);
    }

    public OwserverPacket(DataInputStream owInputStream, OwserverPacketType packetType) throws IOException, OwException {
        this.packetType = packetType;
        this.protocolVersion = owInputStream.readInt();
        this.payloadLength = owInputStream.readInt();
        this.packetCode = owInputStream.readInt();
        this.controlFlags = owInputStream.readInt();
        this.packetSize = owInputStream.readInt();
        this.payloadOffset = owInputStream.readInt();
        if (this.payloadLength != -1) {
            if (this.protocolVersion != 0 || !OwserverControlFlag.OWNET.isSet(this.controlFlags)) {
                throw new OwException("invalid data read");
            }
            if (this.payloadLength > 0) {
                this.payload = new byte[this.payloadLength];
                owInputStream.readFully(this.payload, 0, this.payloadLength);
            }
        }
    }

    public OwserverPacket(OwserverMessageType owMessageType, String path, OwserverControlFlag ... owControlFlags) {
        this(OwserverPacketType.REQUEST);
        this.packetCode = owMessageType.getValue();
        this.setPayload(path);
        this.setTemperatureScale(OwserverTemperatureScale.CENTIGRADE);
        this.setControlFlags(owControlFlags);
        this.packetSize = owMessageType == OwserverMessageType.WRITE ? 0 : 65536;
    }

    public void setControlFlags(OwserverControlFlag ... flags) {
        int i = 0;
        while (i < flags.length) {
            this.controlFlags |= flags[i].getValue();
            ++i;
        }
    }

    public boolean hasControlFlag(OwserverControlFlag flag) {
        return flag.isSet(this.controlFlags);
    }

    public void setPressureScale(OwserverPressureScale pressureScale) {
        this.controlFlags = pressureScale.setFlag(this.controlFlags);
    }

    public OwserverPressureScale getPressureScale() {
        return OwserverPressureScale.getFlag(this.controlFlags);
    }

    public void setTemperatureScale(OwserverTemperatureScale temperatureScale) {
        this.controlFlags = temperatureScale.setFlag(this.controlFlags);
    }

    public OwserverTemperatureScale getTemperatureScale() {
        return OwserverTemperatureScale.getFlag(this.controlFlags);
    }

    public void setPayload(String payload) {
        byte[] bytes = payload.getBytes();
        this.payloadLength = bytes.length + 1;
        this.payload = new byte[this.payloadLength];
        System.arraycopy(bytes, 0, this.payload, 0, bytes.length);
    }

    public void appendPayload(String payload) {
        byte[] appendBytes = payload.getBytes();
        byte[] fullPayload = new byte[this.payload.length + appendBytes.length];
        System.arraycopy(this.payload, 0, fullPayload, 0, this.payload.length);
        System.arraycopy(appendBytes, 0, fullPayload, this.payload.length, appendBytes.length);
        this.packetSize += appendBytes.length;
        this.payloadLength = fullPayload.length;
        this.payload = fullPayload;
    }

    public void setPayload(OwPageBuffer payload) {
        byte[] bytes = payload.getBytes();
        this.payloadLength = bytes.length + 1;
        this.payload = new byte[this.payloadLength];
        System.arraycopy(bytes, 0, this.payload, 0, bytes.length);
    }

    public String getPayloadString() {
        if (this.payloadLength > 0) {
            if (this.payload[this.payloadLength - 1] == 0) {
                return new String(this.payload, 0, this.payloadLength - 1);
            }
            return new String(this.payload, 0, this.payloadLength);
        }
        return "";
    }

    public void setReturnCode(int returnCode) {
        if (this.packetType != OwserverPacketType.RETURN) {
            throw new IllegalStateException("setting return code not allowed in REQUEST packets");
        }
        this.packetCode = returnCode;
    }

    public int getReturnCode() {
        if (this.packetType == OwserverPacketType.RETURN) {
            return this.packetCode;
        }
        throw new IllegalStateException("getting return code not allowed in REQUEST packets");
    }

    public void setMessageType(OwserverMessageType messageType) {
        if (this.packetType != OwserverPacketType.REQUEST) {
            throw new IllegalStateException("setting message type not allowed in RETURN packets");
        }
        this.packetCode = messageType.getValue();
    }

    public OwserverMessageType getMessageType() {
        if (this.packetType == OwserverPacketType.REQUEST) {
            return OwserverMessageType.fromInt(this.packetCode);
        }
        throw new IllegalStateException("getting message type not allowed in RETURN packets");
    }

    public boolean isValidReturnPacket() {
        return this.packetCode == 0 && this.packetType == OwserverPacketType.RETURN;
    }

    public boolean isPingPacket() {
        return this.payloadLength == -1 && this.packetType == OwserverPacketType.RETURN;
    }

    public OwPageBuffer getPayload() {
        OwPageBuffer byteBuffer = new OwPageBuffer(this.payload);
        return byteBuffer;
    }

    public boolean hasPayload() {
        return this.payloadLength > 0;
    }

    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(24 + this.payloadLength);
        byteBuffer.putInt(this.protocolVersion);
        byteBuffer.putInt(this.payloadLength);
        byteBuffer.putInt(this.packetCode);
        byteBuffer.putInt(this.controlFlags);
        byteBuffer.putInt(this.packetSize);
        byteBuffer.putInt(this.payloadOffset);
        if (this.payloadLength > 0) {
            byteBuffer.put(this.payload);
        }
        return byteBuffer.array();
    }

    public String toString() {
        String prefix = this.packetType == OwserverPacketType.RETURN ? String.format("return code %d", this.packetCode) : String.format("messageType %s", new Object[]{OwserverMessageType.fromInt(this.packetCode)});
        return String.format("%s, size %d, controlFlags 0x%08x, payload '%s'", prefix, 24 + this.payloadLength, this.controlFlags, this.getPayloadString().replaceAll("\\p{C}", "?"));
    }
}

