/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.openweathermap.internal.handler;

import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.openweathermap.internal.OpenWeatherMapBindingConstants;
import org.eclipse.smarthome.binding.openweathermap.internal.config.OpenWeatherMapUVIndexConfiguration;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapCommunicationException;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapConfigurationException;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapConnection;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.AbstractOpenWeatherMapHandler;
import org.eclipse.smarthome.binding.openweathermap.internal.model.OpenWeatherMapJsonUVIndexData;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OpenWeatherMapUVIndexHandler
extends AbstractOpenWeatherMapHandler {
    private final Logger logger = LoggerFactory.getLogger(OpenWeatherMapUVIndexHandler.class);
    private static final String CHANNEL_GROUP_FORECAST_PREFIX = "forecastDay";
    private static final Pattern CHANNEL_GROUP_FORECAST_PREFIX_PATTERN = Pattern.compile("forecastDay([0-9]*)");
    private int forecastDays = 6;
    private @Nullable OpenWeatherMapJsonUVIndexData uvindexData;
    private @Nullable List<OpenWeatherMapJsonUVIndexData> uvindexForecastData;

    public OpenWeatherMapUVIndexHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.logger.debug("Initialize OpenWeatherMapUVIndexHandler handler '{}'.", (Object)this.getThing().getUID());
        OpenWeatherMapUVIndexConfiguration config = (OpenWeatherMapUVIndexConfiguration)this.getConfigAs(OpenWeatherMapUVIndexConfiguration.class);
        boolean configValid = true;
        int newForecastDays = config.getForecastDays();
        if (newForecastDays < 1 || newForecastDays > 8) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-not-supported-uvindex-number-of-days");
            configValid = false;
        }
        if (configValid) {
            this.logger.debug("Rebuilding thing '{}'.", (Object)this.getThing().getUID());
            ArrayList<Channel> toBeAddedChannels = new ArrayList<Channel>();
            ArrayList<Channel> toBeRemovedChannels = new ArrayList<Channel>();
            if (this.forecastDays != newForecastDays) {
                int i;
                this.logger.debug("Rebuilding UV index channel groups.");
                if (this.forecastDays > newForecastDays) {
                    if (newForecastDays < 2) {
                        toBeRemovedChannels.addAll(this.removeChannelsOfGroup("forecastTomorrow"));
                    }
                    i = newForecastDays;
                    while (i < this.forecastDays) {
                        toBeRemovedChannels.addAll(this.removeChannelsOfGroup(CHANNEL_GROUP_FORECAST_PREFIX + Integer.toString(i)));
                        ++i;
                    }
                } else {
                    if (this.forecastDays <= 1 && newForecastDays > 1) {
                        toBeAddedChannels.addAll(this.createChannelsForGroup("forecastTomorrow", OpenWeatherMapBindingConstants.CHANNEL_GROUP_TYPE_UVINDEX));
                    }
                    i = this.forecastDays < 2 ? 2 : this.forecastDays;
                    while (i < newForecastDays) {
                        toBeAddedChannels.addAll(this.createChannelsForGroup(CHANNEL_GROUP_FORECAST_PREFIX + Integer.toString(i), OpenWeatherMapBindingConstants.CHANNEL_GROUP_TYPE_UVINDEX));
                        ++i;
                    }
                }
                this.forecastDays = newForecastDays;
            }
            ThingBuilder builder = this.editThing().withoutChannels(toBeRemovedChannels);
            for (Channel channel : toBeAddedChannels) {
                builder.withChannel(channel);
            }
            this.updateThing(builder.build());
        }
    }

    @Override
    protected boolean requestData(OpenWeatherMapConnection connection) throws OpenWeatherMapCommunicationException, OpenWeatherMapConfigurationException {
        this.logger.debug("Update UV Index data of thing '{}'.", (Object)this.getThing().getUID());
        try {
            this.uvindexData = connection.getUVIndexData(this.location);
            if (this.forecastDays > 0) {
                this.uvindexForecastData = connection.getUVIndexForecastData(this.location, this.forecastDays);
            }
            return true;
        }
        catch (JsonSyntaxException e) {
            this.logger.debug("JsonSyntaxException occurred during execution: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return false;
        }
    }

    @Override
    protected void updateChannel(ChannelUID channelUID) {
        switch (channelUID.getGroupId()) {
            case "current": {
                this.updateUVIndexChannel(channelUID);
                break;
            }
            case "forecastTomorrow": {
                this.updateUVIndexForecastChannel(channelUID, 1);
                break;
            }
            default: {
                int i;
                Matcher m = CHANNEL_GROUP_FORECAST_PREFIX_PATTERN.matcher(channelUID.getGroupId());
                if (!m.find() || (i = Integer.parseInt(m.group(1))) <= 1 || i > 8) break;
                this.updateUVIndexForecastChannel(channelUID, i);
            }
        }
    }

    private void updateUVIndexChannel(ChannelUID channelUID) {
        block12: {
            String channelGroupId;
            String channelId;
            block10: {
                channelId = channelUID.getIdWithoutGroup();
                channelGroupId = channelUID.getGroupId();
                if (this.uvindexData == null) break block10;
                UnDefType state = UnDefType.UNDEF;
                switch (channelId) {
                    case "time-stamp": {
                        state = this.getDateTimeTypeState(this.uvindexData.getDate());
                        break;
                    }
                    case "uvindex": {
                        state = this.getDecimalTypeState(this.uvindexData.getValue());
                    }
                }
                this.logger.debug("Update channel '{}' of group '{}' with new state '{}'.", new Object[]{channelId, channelGroupId, state});
                this.updateState(channelUID, (State)state);
                break block12;
            }
            this.logger.debug("No UV Index data available to update channel '{}' of group '{}'.", (Object)channelId, (Object)channelGroupId);
        }
    }

    private void updateUVIndexForecastChannel(ChannelUID channelUID, int count) {
        block12: {
            String channelGroupId;
            String channelId;
            block10: {
                channelId = channelUID.getIdWithoutGroup();
                channelGroupId = channelUID.getGroupId();
                if (this.uvindexForecastData == null || this.uvindexForecastData.size() < count) break block10;
                OpenWeatherMapJsonUVIndexData forecastData = this.uvindexForecastData.get(count - 1);
                UnDefType state = UnDefType.UNDEF;
                switch (channelId) {
                    case "time-stamp": {
                        state = this.getDateTimeTypeState(forecastData.getDate());
                        break;
                    }
                    case "uvindex": {
                        state = this.getDecimalTypeState(forecastData.getValue());
                    }
                }
                this.logger.debug("Update channel '{}' of group '{}' with new state '{}'.", new Object[]{channelId, channelGroupId, state});
                this.updateState(channelUID, (State)state);
                break block12;
            }
            this.logger.debug("No UV Index data available to update channel '{}' of group '{}'.", (Object)channelId, (Object)channelGroupId);
        }
    }
}

