/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.openweathermap.internal.handler;

import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.smarthome.binding.openweathermap.internal.OpenWeatherMapBindingConstants;
import org.eclipse.smarthome.binding.openweathermap.internal.config.OpenWeatherMapWeatherAndForecastConfiguration;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapCommunicationException;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapConfigurationException;
import org.eclipse.smarthome.binding.openweathermap.internal.connection.OpenWeatherMapConnection;
import org.eclipse.smarthome.binding.openweathermap.internal.handler.AbstractOpenWeatherMapHandler;
import org.eclipse.smarthome.binding.openweathermap.internal.model.OpenWeatherMapJsonDailyForecastData;
import org.eclipse.smarthome.binding.openweathermap.internal.model.OpenWeatherMapJsonHourlyForecastData;
import org.eclipse.smarthome.binding.openweathermap.internal.model.OpenWeatherMapJsonWeatherData;
import org.eclipse.smarthome.binding.openweathermap.internal.model.forecast.hourly.List;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OpenWeatherMapWeatherAndForecastHandler
extends AbstractOpenWeatherMapHandler {
    private final Logger logger = LoggerFactory.getLogger(OpenWeatherMapWeatherAndForecastHandler.class);
    private static final String CHANNEL_GROUP_HOURLY_FORECAST_PREFIX = "forecastHours";
    private static final String CHANNEL_GROUP_DAILY_FORECAST_PREFIX = "forecastDay";
    private static final Pattern CHANNEL_GROUP_HOURLY_FORECAST_PREFIX_PATTERN = Pattern.compile("forecastHours([0-9]*)");
    private static final Pattern CHANNEL_GROUP_DAILY_FORECAST_PREFIX_PATTERN = Pattern.compile("forecastDay([0-9]*)");
    private int forecastHours = 24;
    private int forecastDays = 6;
    private @Nullable OpenWeatherMapJsonWeatherData weatherData;
    private @Nullable OpenWeatherMapJsonHourlyForecastData hourlyForecastData;
    private @Nullable OpenWeatherMapJsonDailyForecastData dailyForecastData;

    public OpenWeatherMapWeatherAndForecastHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void initialize() {
        int newForecastDays;
        super.initialize();
        this.logger.debug("Initialize OpenWeatherMapWeatherAndForecastHandler handler '{}'.", (Object)this.getThing().getUID());
        OpenWeatherMapWeatherAndForecastConfiguration config = (OpenWeatherMapWeatherAndForecastConfiguration)this.getConfigAs(OpenWeatherMapWeatherAndForecastConfiguration.class);
        boolean configValid = true;
        int newForecastHours = config.getForecastHours();
        if (newForecastHours < 0 || newForecastHours > 120 || newForecastHours % 3 != 0) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-not-supported-number-of-hours");
            configValid = false;
        }
        if ((newForecastDays = config.getForecastDays()) < 0 || newForecastDays > 16) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "@text/offline.conf-error-not-supported-number-of-days");
            configValid = false;
        }
        if (configValid) {
            int i;
            this.logger.debug("Rebuilding thing '{}'.", (Object)this.getThing().getUID());
            ArrayList<Channel> toBeAddedChannels = new ArrayList<Channel>();
            ArrayList<Channel> toBeRemovedChannels = new ArrayList<Channel>();
            if (this.forecastHours != newForecastHours) {
                this.logger.debug("Rebuilding hourly forecast channel groups.");
                if (this.forecastHours > newForecastHours) {
                    i = newForecastHours + 3;
                    while (i <= this.forecastHours) {
                        toBeRemovedChannels.addAll(this.removeChannelsOfGroup(CHANNEL_GROUP_HOURLY_FORECAST_PREFIX + (i < 10 ? "0" : "") + Integer.toString(i)));
                        i += 3;
                    }
                } else {
                    i = this.forecastHours + 3;
                    while (i <= newForecastHours) {
                        toBeAddedChannels.addAll(this.createChannelsForGroup(CHANNEL_GROUP_HOURLY_FORECAST_PREFIX + (i < 10 ? "0" : "") + Integer.toString(i), OpenWeatherMapBindingConstants.CHANNEL_GROUP_TYPE_HOURLY_FORECAST));
                        i += 3;
                    }
                }
                this.forecastHours = newForecastHours;
            }
            if (this.forecastDays != newForecastDays) {
                this.logger.debug("Rebuilding daily forecast channel groups.");
                if (this.forecastDays > newForecastDays) {
                    if (newForecastDays < 1) {
                        toBeRemovedChannels.addAll(this.removeChannelsOfGroup("forecastToday"));
                    }
                    if (newForecastDays < 2) {
                        toBeRemovedChannels.addAll(this.removeChannelsOfGroup("forecastTomorrow"));
                    }
                    i = newForecastDays;
                    while (i < this.forecastDays) {
                        toBeRemovedChannels.addAll(this.removeChannelsOfGroup(CHANNEL_GROUP_DAILY_FORECAST_PREFIX + Integer.toString(i)));
                        ++i;
                    }
                } else {
                    if (this.forecastDays == 0 && newForecastDays > 0) {
                        toBeAddedChannels.addAll(this.createChannelsForGroup("forecastToday", OpenWeatherMapBindingConstants.CHANNEL_GROUP_TYPE_DAILY_FORECAST));
                    }
                    if (this.forecastDays <= 1 && newForecastDays > 1) {
                        toBeAddedChannels.addAll(this.createChannelsForGroup("forecastTomorrow", OpenWeatherMapBindingConstants.CHANNEL_GROUP_TYPE_DAILY_FORECAST));
                    }
                    i = this.forecastDays < 2 ? 2 : this.forecastDays;
                    while (i < newForecastDays) {
                        toBeAddedChannels.addAll(this.createChannelsForGroup(CHANNEL_GROUP_DAILY_FORECAST_PREFIX + Integer.toString(i), OpenWeatherMapBindingConstants.CHANNEL_GROUP_TYPE_DAILY_FORECAST));
                        ++i;
                    }
                }
                this.forecastDays = newForecastDays;
            }
            ThingBuilder builder = this.editThing().withoutChannels(toBeRemovedChannels);
            for (Channel channel : toBeAddedChannels) {
                builder.withChannel(channel);
            }
            this.updateThing(builder.build());
        }
    }

    @Override
    protected boolean requestData(OpenWeatherMapConnection connection) throws OpenWeatherMapCommunicationException, OpenWeatherMapConfigurationException {
        this.logger.debug("Update weather and forecast data of thing '{}'.", (Object)this.getThing().getUID());
        try {
            this.weatherData = connection.getWeatherData(this.location);
            if (this.forecastHours > 0) {
                this.hourlyForecastData = connection.getHourlyForecastData(this.location, this.forecastHours / 3);
            }
            if (this.forecastDays > 0) {
                try {
                    this.dailyForecastData = connection.getDailyForecastData(this.location, this.forecastDays);
                }
                catch (OpenWeatherMapConfigurationException e) {
                    if (e.getCause() instanceof HttpResponseException) {
                        this.forecastDays = 0;
                        Configuration editConfig = this.editConfiguration();
                        editConfig.put("forecastDays", (Object)0);
                        this.updateConfiguration(editConfig);
                        this.logger.debug("Removing daily forecast channel groups.");
                        java.util.List channels = this.getThing().getChannels().stream().filter(c -> "forecastToday".equals(c.getUID().getGroupId()) || "forecastTomorrow".equals(c.getUID().getGroupId()) || c.getUID().getGroupId().startsWith(CHANNEL_GROUP_DAILY_FORECAST_PREFIX)).collect(Collectors.toList());
                        this.updateThing(this.editThing().withoutChannels(channels).build());
                    }
                    throw e;
                }
            }
            return true;
        }
        catch (JsonSyntaxException e) {
            this.logger.debug("JsonSyntaxException occurred during execution: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return false;
        }
    }

    @Override
    protected void updateChannel(ChannelUID channelUID) {
        String channelGroupId;
        switch (channelGroupId = channelUID.getGroupId()) {
            case "station": 
            case "current": {
                this.updateCurrentChannel(channelUID);
                break;
            }
            case "forecastToday": {
                this.updateDailyForecastChannel(channelUID, 0);
                break;
            }
            case "forecastTomorrow": {
                this.updateDailyForecastChannel(channelUID, 1);
                break;
            }
            default: {
                int i;
                Matcher hourlyForecastMatcher = CHANNEL_GROUP_HOURLY_FORECAST_PREFIX_PATTERN.matcher(channelGroupId);
                if (hourlyForecastMatcher.find() && (i = Integer.parseInt(hourlyForecastMatcher.group(1))) >= 3 && i <= 120) {
                    this.updateHourlyForecastChannel(channelUID, i / 3 - 1);
                    break;
                }
                Matcher dailyForecastMatcher = CHANNEL_GROUP_DAILY_FORECAST_PREFIX_PATTERN.matcher(channelGroupId);
                if (!dailyForecastMatcher.find() || (i = Integer.parseInt(dailyForecastMatcher.group(1))) <= 1 || i > 16) break;
                this.updateDailyForecastChannel(channelUID, i);
            }
        }
    }

    private void updateCurrentChannel(ChannelUID channelUID) {
        block57: {
            String channelGroupId;
            String channelId;
            block55: {
                channelId = channelUID.getIdWithoutGroup();
                channelGroupId = channelUID.getGroupId();
                if (this.weatherData == null) break block55;
                UnDefType state = UnDefType.UNDEF;
                switch (channelId) {
                    case "id": {
                        state = this.getStringTypeState(this.weatherData.getId().toString());
                        break;
                    }
                    case "name": {
                        state = this.getStringTypeState(this.weatherData.getName());
                        break;
                    }
                    case "location": {
                        state = this.getPointTypeState(this.weatherData.getCoord().getLat(), this.weatherData.getCoord().getLon());
                        break;
                    }
                    case "time-stamp": {
                        state = this.getDateTimeTypeState(this.weatherData.getDt());
                        break;
                    }
                    case "condition": {
                        state = this.getStringTypeState(this.weatherData.getWeather().get(0).getDescription());
                        break;
                    }
                    case "condition-id": {
                        state = this.getStringTypeState(this.weatherData.getWeather().get(0).getId().toString());
                        break;
                    }
                    case "icon": {
                        state = this.getRawTypeState(OpenWeatherMapConnection.getWeatherIcon(this.weatherData.getWeather().get(0).getIcon()));
                        break;
                    }
                    case "icon-id": {
                        state = this.getStringTypeState(this.weatherData.getWeather().get(0).getIcon());
                        break;
                    }
                    case "temperature": {
                        state = this.getQuantityTypeState(this.weatherData.getMain().getTemp(), SIUnits.CELSIUS);
                        break;
                    }
                    case "pressure": {
                        state = this.getQuantityTypeState(this.weatherData.getMain().getPressure(), MetricPrefix.HECTO((Unit)SIUnits.PASCAL));
                        break;
                    }
                    case "humidity": {
                        state = this.getQuantityTypeState(this.weatherData.getMain().getHumidity(), SmartHomeUnits.PERCENT);
                        break;
                    }
                    case "wind-speed": {
                        state = this.getQuantityTypeState(this.weatherData.getWind().getSpeed(), SmartHomeUnits.METRE_PER_SECOND);
                        break;
                    }
                    case "wind-direction": {
                        state = this.getQuantityTypeState(this.weatherData.getWind().getDeg(), SmartHomeUnits.DEGREE_ANGLE);
                        break;
                    }
                    case "gust-speed": {
                        state = this.getQuantityTypeState(this.weatherData.getWind().getGust(), SmartHomeUnits.METRE_PER_SECOND);
                        break;
                    }
                    case "cloudiness": {
                        state = this.getQuantityTypeState(this.weatherData.getClouds().getAll(), SmartHomeUnits.PERCENT);
                        break;
                    }
                    case "rain": {
                        state = this.getQuantityTypeState(this.weatherData.getRain() == null || this.weatherData.getRain().get3h() == null ? 0.0 : this.weatherData.getRain().get3h(), MetricPrefix.MILLI((Unit)SIUnits.METRE));
                        break;
                    }
                    case "snow": {
                        state = this.getQuantityTypeState(this.weatherData.getSnow() == null || this.weatherData.getSnow().get3h() == null ? 0.0 : this.weatherData.getSnow().get3h(), MetricPrefix.MILLI((Unit)SIUnits.METRE));
                    }
                }
                this.logger.debug("Update channel '{}' of group '{}' with new state '{}'.", new Object[]{channelId, channelGroupId, state});
                this.updateState(channelUID, (State)state);
                break block57;
            }
            this.logger.debug("No weather data available to update channel '{}' of group '{}'.", (Object)channelId, (Object)channelGroupId);
        }
    }

    private void updateHourlyForecastChannel(ChannelUID channelUID, int count) {
        block48: {
            String channelGroupId;
            String channelId;
            block46: {
                channelId = channelUID.getIdWithoutGroup();
                channelGroupId = channelUID.getGroupId();
                if (this.hourlyForecastData == null || this.hourlyForecastData.getList().size() <= count) break block46;
                List forecastData = this.hourlyForecastData.getList().get(count);
                UnDefType state = UnDefType.UNDEF;
                switch (channelId) {
                    case "time-stamp": {
                        state = this.getDateTimeTypeState(forecastData.getDt());
                        break;
                    }
                    case "condition": {
                        state = this.getStringTypeState(forecastData.getWeather().get(0).getDescription());
                        break;
                    }
                    case "condition-id": {
                        state = this.getStringTypeState(forecastData.getWeather().get(0).getId().toString());
                        break;
                    }
                    case "icon": {
                        state = this.getRawTypeState(OpenWeatherMapConnection.getWeatherIcon(forecastData.getWeather().get(0).getIcon()));
                        break;
                    }
                    case "icon-id": {
                        state = this.getStringTypeState(forecastData.getWeather().get(0).getIcon());
                        break;
                    }
                    case "temperature": {
                        state = this.getQuantityTypeState(forecastData.getMain().getTemp(), SIUnits.CELSIUS);
                        break;
                    }
                    case "pressure": {
                        state = this.getQuantityTypeState(forecastData.getMain().getPressure(), MetricPrefix.HECTO((Unit)SIUnits.PASCAL));
                        break;
                    }
                    case "humidity": {
                        state = this.getQuantityTypeState(forecastData.getMain().getHumidity(), SmartHomeUnits.PERCENT);
                        break;
                    }
                    case "wind-speed": {
                        state = this.getQuantityTypeState(forecastData.getWind().getSpeed(), SmartHomeUnits.METRE_PER_SECOND);
                        break;
                    }
                    case "wind-direction": {
                        state = this.getQuantityTypeState(forecastData.getWind().getDeg(), SmartHomeUnits.DEGREE_ANGLE);
                        break;
                    }
                    case "gust-speed": {
                        state = this.getQuantityTypeState(forecastData.getWind().getGust(), SmartHomeUnits.METRE_PER_SECOND);
                        break;
                    }
                    case "cloudiness": {
                        state = this.getQuantityTypeState(forecastData.getClouds().getAll(), SmartHomeUnits.PERCENT);
                        break;
                    }
                    case "rain": {
                        state = this.getQuantityTypeState(forecastData.getRain() == null || forecastData.getRain().get3h() == null ? 0.0 : forecastData.getRain().get3h(), MetricPrefix.MILLI((Unit)SIUnits.METRE));
                        break;
                    }
                    case "snow": {
                        state = this.getQuantityTypeState(forecastData.getSnow() == null || forecastData.getSnow().get3h() == null ? 0.0 : forecastData.getSnow().get3h(), MetricPrefix.MILLI((Unit)SIUnits.METRE));
                    }
                }
                this.logger.debug("Update channel '{}' of group '{}' with new state '{}'.", new Object[]{channelId, channelGroupId, state});
                this.updateState(channelUID, (State)state);
                break block48;
            }
            this.logger.debug("No weather data available to update channel '{}' of group '{}'.", (Object)channelId, (Object)channelGroupId);
        }
    }

    private void updateDailyForecastChannel(ChannelUID channelUID, int count) {
        block51: {
            String channelGroupId;
            String channelId;
            block49: {
                channelId = channelUID.getIdWithoutGroup();
                channelGroupId = channelUID.getGroupId();
                if (this.dailyForecastData == null || this.dailyForecastData.getList().size() <= count) break block49;
                org.eclipse.smarthome.binding.openweathermap.internal.model.forecast.daily.List forecastData = this.dailyForecastData.getList().get(count);
                UnDefType state = UnDefType.UNDEF;
                switch (channelId) {
                    case "time-stamp": {
                        state = this.getDateTimeTypeState(forecastData.getDt());
                        break;
                    }
                    case "condition": {
                        state = this.getStringTypeState(forecastData.getWeather().get(0).getDescription());
                        break;
                    }
                    case "condition-id": {
                        state = this.getStringTypeState(forecastData.getWeather().get(0).getId().toString());
                        break;
                    }
                    case "icon": {
                        state = this.getRawTypeState(OpenWeatherMapConnection.getWeatherIcon(forecastData.getWeather().get(0).getIcon()));
                        break;
                    }
                    case "icon-id": {
                        state = this.getStringTypeState(forecastData.getWeather().get(0).getIcon());
                        break;
                    }
                    case "min-temperature": {
                        state = this.getQuantityTypeState(forecastData.getTemp().getMin(), SIUnits.CELSIUS);
                        break;
                    }
                    case "max-temperature": {
                        state = this.getQuantityTypeState(forecastData.getTemp().getMax(), SIUnits.CELSIUS);
                        break;
                    }
                    case "pressure": {
                        state = this.getQuantityTypeState(forecastData.getPressure(), MetricPrefix.HECTO((Unit)SIUnits.PASCAL));
                        break;
                    }
                    case "humidity": {
                        state = this.getQuantityTypeState(forecastData.getHumidity(), SmartHomeUnits.PERCENT);
                        break;
                    }
                    case "wind-speed": {
                        state = this.getQuantityTypeState(forecastData.getSpeed(), SmartHomeUnits.METRE_PER_SECOND);
                        break;
                    }
                    case "wind-direction": {
                        state = this.getQuantityTypeState(forecastData.getDeg(), SmartHomeUnits.DEGREE_ANGLE);
                        break;
                    }
                    case "gust-speed": {
                        state = this.getQuantityTypeState(forecastData.getGust(), SmartHomeUnits.METRE_PER_SECOND);
                        break;
                    }
                    case "cloudiness": {
                        state = this.getQuantityTypeState(forecastData.getClouds(), SmartHomeUnits.PERCENT);
                        break;
                    }
                    case "rain": {
                        state = this.getQuantityTypeState(forecastData.getRain() == null ? 0.0 : forecastData.getRain(), MetricPrefix.MILLI((Unit)SIUnits.METRE));
                        break;
                    }
                    case "snow": {
                        state = this.getQuantityTypeState(forecastData.getSnow() == null ? 0.0 : forecastData.getSnow(), MetricPrefix.MILLI((Unit)SIUnits.METRE));
                    }
                }
                this.logger.debug("Update channel '{}' of group '{}' with new state '{}'.", new Object[]{channelId, channelGroupId, state});
                this.updateState(channelUID, (State)state);
                break block51;
            }
            this.logger.debug("No weather data available to update channel '{}' of group '{}'.", (Object)channelId, (Object)channelGroupId);
        }
    }
}

