/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.openweathermap.internal.utils;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ByteArrayFileCache {
    private final Logger logger = LoggerFactory.getLogger(ByteArrayFileCache.class);
    private static final String CACHE_FOLDER_NAME = "cache";
    public static final char EXTENSION_SEPARATOR = '.';
    protected final File cacheFolder;

    public ByteArrayFileCache(String servicePID) {
        this.cacheFolder = new File(new File(new File(ConfigConstants.getUserDataFolder()), CACHE_FOLDER_NAME), servicePID);
        if (!this.cacheFolder.exists()) {
            this.logger.debug("Creating cache folder '{}'", (Object)this.cacheFolder.getAbsolutePath());
            this.cacheFolder.mkdirs();
        }
        this.logger.debug("Using cache folder '{}'", (Object)this.cacheFolder.getAbsolutePath());
    }

    public void put(String key, byte[] content) {
        this.writeFile(this.getUniqueFile(key), content);
    }

    public void putIfAbsent(String key, byte[] content) {
        File fileInCache = this.getUniqueFile(key);
        if (fileInCache.exists()) {
            this.logger.debug("File '{}' present in cache", (Object)fileInCache.getName());
        } else {
            this.writeFile(fileInCache, content);
        }
    }

    public byte[] putIfAbsentAndGet(String key, byte[] content) {
        this.putIfAbsent(key, content);
        return content;
    }

    private void writeFile(File fileInCache, byte[] content) {
        this.logger.debug("Caching file '{}'", (Object)fileInCache.getName());
        try {
            Files.write(fileInCache.toPath(), content, new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.warn("Could not write file '{}'\u00a0to cache", (Object)fileInCache.getName(), (Object)e);
        }
    }

    public boolean containsKey(String key) {
        return this.getUniqueFile(key).exists();
    }

    public void remove(String key) {
        this.deleteFile(this.getUniqueFile(key));
    }

    private void deleteFile(File fileInCache) {
        if (fileInCache.exists()) {
            this.logger.debug("Deleting file '{}' from cache", (Object)fileInCache.getName());
            fileInCache.delete();
        } else {
            this.logger.debug("File '{}' not found in cache", (Object)fileInCache.getName());
        }
    }

    public void clear() {
        File[] filesInCache = this.cacheFolder.listFiles();
        if (filesInCache != null && filesInCache.length > 0) {
            this.logger.debug("Deleting all files from cache");
            Arrays.stream(filesInCache).forEach(File::delete);
        }
    }

    public byte[] get(String key) {
        return this.readFile(this.getUniqueFile(key));
    }

    private byte[] readFile(File fileInCache) {
        if (fileInCache.exists()) {
            this.logger.debug("Reading file '{}' from cache", (Object)fileInCache.getName());
            try {
                return Files.readAllBytes(fileInCache.toPath());
            }
            catch (IOException e) {
                this.logger.warn("Could not read file '{}'\u00a0from cache", (Object)fileInCache.getName(), (Object)e);
            }
        } else {
            this.logger.debug("File '{}' not found in cache", (Object)fileInCache.getName());
        }
        return new byte[0];
    }

    private File getUniqueFile(String key) {
        String fileExtension = this.getFileExtension(key);
        return new File(this.cacheFolder, String.valueOf(this.getUniqueFileName(key)) + (fileExtension == null ? "" : String.valueOf('.') + fileExtension));
    }

    private @Nullable String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return null;
    }

    private String getUniqueFileName(String key) {
        try {
            byte[] bytesOfFileName = key.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5Hash = md.digest(bytesOfFileName);
            BigInteger bigInt = new BigInteger(1, md5Hash);
            StringBuilder fileNameHash = new StringBuilder(bigInt.toString(16));
            while (fileNameHash.length() < 32) {
                fileNameHash.insert(0, "0");
            }
            return fileNameHash.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.error("Could not create MD5 hash for key '{}'", (Object)key, (Object)ex);
            return key.toString();
        }
    }
}

