/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionAliasProvider;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterGroup;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.ConfigOptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ConfigDescriptionRegistry.class})
public class ConfigDescriptionRegistry {
    private final Logger logger = LoggerFactory.getLogger(ConfigDescriptionRegistry.class);
    private final List<ConfigOptionProvider> configOptionProviders = new CopyOnWriteArrayList<ConfigOptionProvider>();
    private final List<ConfigDescriptionProvider> configDescriptionProviders = new CopyOnWriteArrayList<ConfigDescriptionProvider>();
    private final List<ConfigDescriptionAliasProvider> configDescriptionAliasProviders = new CopyOnWriteArrayList<ConfigDescriptionAliasProvider>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addConfigOptionProvider(ConfigOptionProvider configOptionProvider) {
        if (configOptionProvider != null) {
            this.configOptionProviders.add(configOptionProvider);
        }
    }

    protected void removeConfigOptionProvider(ConfigOptionProvider configOptionProvider) {
        if (configOptionProvider != null) {
            this.configOptionProviders.remove(configOptionProvider);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        if (configDescriptionProvider != null) {
            this.configDescriptionProviders.add(configDescriptionProvider);
        }
    }

    protected void removeConfigDescriptionProvider(ConfigDescriptionProvider configDescriptionProvider) {
        if (configDescriptionProvider != null) {
            this.configDescriptionProviders.remove(configDescriptionProvider);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addConfigDescriptionAliasProvider(ConfigDescriptionAliasProvider configDescriptionAliasProvider) {
        if (configDescriptionAliasProvider != null) {
            this.configDescriptionAliasProviders.add(configDescriptionAliasProvider);
        }
    }

    protected void removeConfigDescriptionAliasProvider(ConfigDescriptionAliasProvider configDescriptionAliasProvider) {
        if (configDescriptionAliasProvider != null) {
            this.configDescriptionAliasProviders.remove(configDescriptionAliasProvider);
        }
    }

    public Collection<ConfigDescription> getConfigDescriptions(Locale locale) {
        HashMap<URI, ConfigDescription> configMap = new HashMap<URI, ConfigDescription>();
        for (ConfigDescriptionProvider configDescriptionProvider : this.configDescriptionProviders) {
            for (ConfigDescription configDescription : configDescriptionProvider.getConfigDescriptions(locale)) {
                ConfigDescription configFromMap = (ConfigDescription)configMap.get(configDescription.getUID());
                if (configFromMap != null) {
                    ArrayList<ConfigDescriptionParameter> parameters = new ArrayList<ConfigDescriptionParameter>();
                    parameters.addAll(configFromMap.getParameters());
                    parameters.addAll(configDescription.getParameters());
                    ArrayList<ConfigDescriptionParameterGroup> parameterGroups = new ArrayList<ConfigDescriptionParameterGroup>();
                    parameterGroups.addAll(configFromMap.getParameterGroups());
                    parameterGroups.addAll(configDescription.getParameterGroups());
                    configMap.put(configDescription.getUID(), new ConfigDescription(configDescription.getUID(), parameters, parameterGroups));
                    continue;
                }
                configMap.put(configDescription.getUID(), configDescription);
            }
        }
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>(configMap.size());
        for (ConfigDescription configDescription : configMap.values()) {
            configDescriptions.add(configDescription);
        }
        return Collections.unmodifiableCollection(configDescriptions);
    }

    public Collection<ConfigDescription> getConfigDescriptions() {
        return this.getConfigDescriptions(null);
    }

    public @Nullable ConfigDescription getConfigDescription(URI uri, Locale locale) {
        ArrayList<ConfigDescriptionParameter> parameters = new ArrayList<ConfigDescriptionParameter>();
        ArrayList<ConfigDescriptionParameterGroup> parameterGroups = new ArrayList<ConfigDescriptionParameterGroup>();
        boolean found = false;
        Set<URI> aliases = this.getAliases(uri);
        for (URI alias : aliases) {
            this.logger.debug("No config description found for '{}', using alias '{}' instead", (Object)uri, (Object)alias);
            found |= this.fillFromProviders(alias, locale, parameters, parameterGroups);
        }
        if (found |= this.fillFromProviders(uri, locale, parameters, parameterGroups)) {
            ArrayList<ConfigDescriptionParameter> parametersWithOptions = new ArrayList<ConfigDescriptionParameter>(parameters.size());
            for (ConfigDescriptionParameter parameter : parameters) {
                parametersWithOptions.add(this.getConfigOptions(uri, aliases, parameter, locale));
            }
            return new ConfigDescription(uri, parametersWithOptions, parameterGroups);
        }
        return null;
    }

    private Set<URI> getAliases(URI original) {
        LinkedHashSet<URI> ret = new LinkedHashSet<URI>();
        for (ConfigDescriptionAliasProvider aliasProvider : this.configDescriptionAliasProviders) {
            URI alias = aliasProvider.getAlias(original);
            if (alias == null) continue;
            ret.add(alias);
        }
        return ret;
    }

    private boolean fillFromProviders(URI uri, Locale locale, List<ConfigDescriptionParameter> parameters, List<ConfigDescriptionParameterGroup> parameterGroups) {
        boolean found = false;
        for (ConfigDescriptionProvider configDescriptionProvider : this.configDescriptionProviders) {
            ConfigDescription config = configDescriptionProvider.getConfigDescription(uri, locale);
            if (config == null) continue;
            found = true;
            parameters.addAll(config.getParameters());
            parameterGroups.addAll(config.getParameterGroups());
        }
        return found;
    }

    public @Nullable ConfigDescription getConfigDescription(URI uri) {
        return this.getConfigDescription(uri, null);
    }

    private ConfigDescriptionParameter getConfigOptions(URI uri, Set<URI> aliases, ConfigDescriptionParameter parameter, Locale locale) {
        ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
        options.addAll(parameter.getOptions());
        boolean found = this.fillFromProviders(uri, parameter, locale, options);
        if (!found && aliases != null) {
            for (URI alias : aliases) {
                found = this.fillFromProviders(alias, parameter, locale, options);
                if (found) break;
            }
        }
        if (found) {
            return new ConfigDescriptionParameter(parameter.getName(), parameter.getType(), parameter.getMinimum(), parameter.getMaximum(), parameter.getStepSize(), parameter.getPattern(), parameter.isRequired(), parameter.isReadOnly(), parameter.isMultiple(), parameter.getContext(), parameter.getDefault(), parameter.getLabel(), parameter.getDescription(), options, parameter.getFilterCriteria(), parameter.getGroupName(), parameter.isAdvanced(), parameter.getLimitToOptions(), parameter.getMultipleLimit(), parameter.getUnit(), parameter.getUnitLabel(), parameter.isVerifyable());
        }
        return parameter;
    }

    private boolean fillFromProviders(URI alias, ConfigDescriptionParameter parameter, Locale locale, List<ParameterOption> options) {
        boolean found = false;
        for (ConfigOptionProvider configOptionProvider : this.configOptionProviders) {
            Collection<ParameterOption> newOptions = configOptionProvider.getParameterOptions(alias, parameter.getName(), parameter.getContext(), locale);
            if (newOptions == null) continue;
            found = true;
            options.addAll(newOptions);
        }
        return found;
    }
}

