/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.internal.ConfigMapper;

public class Configuration {
    private final Map<String, Object> properties;

    public Configuration() {
        this(null, true);
    }

    public Configuration(@Nullable Configuration configuration) {
        this(configuration != null ? configuration.properties : null, true);
    }

    public Configuration(Map<String, Object> properties) {
        this(properties, false);
    }

    private Configuration(@Nullable Map<String, Object> properties, boolean alreadyNormalized) {
        this.properties = properties == null ? new HashMap<String, Object>() : (alreadyNormalized ? new HashMap<String, Object>(properties) : ConfigUtil.normalizeTypes(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T as(Class<T> configurationClass) {
        Configuration configuration = this;
        synchronized (configuration) {
            return ConfigMapper.as(this.properties, configurationClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.containsKey(key);
        }
    }

    @Deprecated
    public Object get(Object key) {
        return this.get((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(String key, Object value) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.put(key, ConfigUtil.normalizeType(value, null));
        }
    }

    @Deprecated
    public Object remove(Object key) {
        return this.remove((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String key) {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        Configuration configuration = this;
        synchronized (configuration) {
            return Collections.unmodifiableSet(new HashSet<String>(this.properties.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> values() {
        Configuration configuration = this;
        synchronized (configuration) {
            return Collections.unmodifiableCollection(new ArrayList<Object>(this.properties.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        Configuration configuration = this;
        synchronized (configuration) {
            return Collections.unmodifiableMap(new HashMap<String, Object>(this.properties));
        }
    }

    public void setProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entrySet : properties.entrySet()) {
            this.put(entrySet.getKey(), entrySet.getValue());
        }
        Iterator<String> it = this.properties.keySet().iterator();
        while (it.hasNext()) {
            String entry = it.next();
            if (properties.containsKey(entry)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Configuration configuration = this;
        synchronized (configuration) {
            return this.properties.hashCode();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration[");
        boolean first = true;
        for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = prop.getValue();
            sb.append(String.format("{key=%s; type=%s; value=%s}", prop.getKey(), value != null ? value.getClass().getSimpleName() : "?", value));
        }
        sb.append("]");
        return sb.toString();
    }
}

