/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.i18n;

import java.net.URI;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ConfigDescriptionI18nUtil {
    private final TranslationProvider i18nProvider;
    private static final Pattern DELIMITER = Pattern.compile("[:=\\s]");

    public ConfigDescriptionI18nUtil(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public String getParameterPattern(Bundle bundle, URI configDescriptionURI, String parameterName, String defaultPattern, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultPattern, () -> this.inferKey(configDescriptionURI, parameterName, "pattern"));
        return this.i18nProvider.getText(bundle, key, defaultPattern, locale);
    }

    public String getParameterDescription(Bundle bundle, URI configDescriptionURI, String parameterName, String defaultDescription, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultDescription, () -> this.inferKey(configDescriptionURI, parameterName, "description"));
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getParameterLabel(Bundle bundle, URI configDescriptionURI, String parameterName, String defaultLabel, Locale locale) {
        String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferKey(configDescriptionURI, parameterName, "label"));
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public String getParameterOptionLabel(Bundle bundle, URI configDescriptionURI, String parameterName, String optionValue, String defaultOptionLabel, Locale locale) {
        if (!this.isValidPropertyKey(optionValue)) {
            return defaultOptionLabel;
        }
        String key = I18nUtil.stripConstantOr((String)defaultOptionLabel, () -> this.inferKey(configDescriptionURI, parameterName, "option." + optionValue));
        return this.i18nProvider.getText(bundle, key, defaultOptionLabel, locale);
    }

    public String getParameterUnitLabel(Bundle bundle, URI configDescriptionURI, String parameterName, String unit, String defaultUnitLabel, Locale locale) {
        String label;
        if (unit != null && defaultUnitLabel == null && (label = this.i18nProvider.getText(FrameworkUtil.getBundle(this.getClass()), "unit." + unit, null, locale)) != null) {
            return label;
        }
        String key = I18nUtil.stripConstantOr((String)defaultUnitLabel, () -> this.inferKey(configDescriptionURI, parameterName, "unitLabel"));
        return this.i18nProvider.getText(bundle, key, defaultUnitLabel, locale);
    }

    private String inferKey(URI configDescriptionURI, String parameterName, String lastSegment) {
        String uri = configDescriptionURI.getSchemeSpecificPart().replace(":", ".");
        return String.valueOf(configDescriptionURI.getScheme()) + ".config." + uri + "." + parameterName + "." + lastSegment;
    }

    private boolean isValidPropertyKey(String key) {
        if (key != null) {
            return !DELIMITER.matcher(key).find();
        }
        return false;
    }
}

