/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapper {
    private static final transient Logger logger = LoggerFactory.getLogger(ConfigMapper.class);

    public static <T> @Nullable T as(Map<String, Object> properties, Class<T> configurationClass) {
        T configuration = null;
        try {
            configuration = configurationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            return null;
        }
        List<Field> fields = ConfigMapper.getAllFields(configurationClass);
        for (Field field : fields) {
            String fieldName;
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            String configKey = fieldName = field.getName();
            Class<?> type = field.getType();
            ArrayList<Object> value = properties.get(configKey);
            if (value == null) {
                logger.trace("Skipping field '{}', because config has no entry for {}", (Object)fieldName, (Object)configKey);
                continue;
            }
            if (value instanceof Collection) {
                Collection c = value;
                Class innerClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                ArrayList<Object> lst = new ArrayList<Object>(c.size());
                for (Object it : c) {
                    Object normalized = ConfigMapper.objectConvert(it, innerClass);
                    lst.add(normalized);
                }
                value = lst;
            }
            try {
                value = ConfigMapper.objectConvert(value, type);
                logger.trace("Setting value ({}) {} to field '{}' in configuration class {}", new Object[]{type.getSimpleName(), value, fieldName, configurationClass.getName()});
                FieldUtils.writeField(configuration, (String)fieldName, value, (boolean)true);
            }
            catch (Exception ex) {
                logger.warn("Could not set field value for field '{}': {}", new Object[]{fieldName, ex.getMessage(), ex});
            }
        }
        return configuration;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> currentClass = clazz;
        while (currentClass != null) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            currentClass = currentClass.getSuperclass();
        }
        return fields;
    }

    private static Object objectConvert(Object value, Class<?> type) {
        List<Object> result = value;
        String typeName = type.getSimpleName();
        if (value instanceof BigDecimal && !type.equals(BigDecimal.class)) {
            BigDecimal bdValue = (BigDecimal)((Object)value);
            if (type.equals(Float.class) || typeName.equals("float")) {
                result = Float.valueOf(bdValue.floatValue());
            } else if (type.equals(Double.class) || typeName.equals("double")) {
                result = bdValue.doubleValue();
            } else if (type.equals(Long.class) || typeName.equals("long")) {
                result = bdValue.longValue();
            } else if (type.equals(Integer.class) || typeName.equals("int")) {
                result = bdValue.intValue();
            }
        } else if (value instanceof String && !type.equals(String.class)) {
            String bdValue = (String)((Object)value);
            if (type.equals(Float.class) || typeName.equals("float")) {
                result = Float.valueOf(bdValue);
            } else if (type.equals(Double.class) || typeName.equals("double")) {
                result = Double.valueOf(bdValue);
            } else if (type.equals(Long.class) || typeName.equals("long")) {
                result = Long.valueOf(bdValue);
            } else if (type.equals(BigDecimal.class)) {
                result = new BigDecimal(bdValue);
            } else if (type.equals(Integer.class) || typeName.equals("int")) {
                result = Integer.valueOf(bdValue);
            } else if (type.equals(Boolean.class) || typeName.equals("boolean")) {
                result = Boolean.valueOf(bdValue);
            } else if (type.isEnum()) {
                Class<?> enumType = type;
                Object enumvalue = Enum.valueOf(enumType, value.toString());
                result = enumvalue;
            } else if (Collection.class.isAssignableFrom(type)) {
                result = Collections.singletonList(value);
            }
        }
        return result;
    }
}

