/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.metadata;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.core.metadata.MetadataConfigDescriptionProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
@NonNullByDefault
public class MetadataConfigDescriptionProviderImpl
implements ConfigDescriptionProvider {
    static final String SCHEME = "metadata";
    static final String SEPARATOR = ":";
    private final List<MetadataConfigDescriptionProvider> providers = new CopyOnWriteArrayList<MetadataConfigDescriptionProvider>();

    @Override
    public Collection<ConfigDescription> getConfigDescriptions(@Nullable Locale locale) {
        LinkedList<ConfigDescription> ret = new LinkedList<ConfigDescription>();
        ret.addAll(this.getValueConfigDescriptions(locale));
        return ret;
    }

    @Override
    public @Nullable ConfigDescription getConfigDescription(URI uri, @Nullable Locale locale) {
        if (!SCHEME.equals(uri.getScheme())) {
            return null;
        }
        String part = uri.getSchemeSpecificPart();
        String namespace = part.contains(SEPARATOR) ? part.substring(0, part.indexOf(SEPARATOR)) : part;
        String value = part.contains(SEPARATOR) ? part.substring(part.indexOf(SEPARATOR) + 1) : null;
        for (MetadataConfigDescriptionProvider provider : this.providers) {
            if (!namespace.equals(provider.getNamespace())) continue;
            if (value == null) {
                return this.createValueConfigDescription(provider, locale);
            }
            return this.createParamConfigDescription(provider, value, locale);
        }
        return null;
    }

    private List<ConfigDescription> getValueConfigDescriptions(@Nullable Locale locale) {
        LinkedList<ConfigDescription> ret = new LinkedList<ConfigDescription>();
        for (MetadataConfigDescriptionProvider provider : this.providers) {
            ret.add(this.createValueConfigDescription(provider, locale));
        }
        return ret;
    }

    private ConfigDescription createValueConfigDescription(MetadataConfigDescriptionProvider provider, @Nullable Locale locale) {
        String namespace = provider.getNamespace();
        String description = provider.getDescription(locale);
        List<ParameterOption> options = provider.getParameterOptions(locale);
        URI uri = URI.create("metadata:" + namespace);
        ConfigDescriptionParameterBuilder builder = ConfigDescriptionParameterBuilder.create("value", ConfigDescriptionParameter.Type.TEXT);
        if (options != null && !options.isEmpty()) {
            builder.withOptions(options);
            builder.withLimitToOptions(true);
        } else {
            builder.withLimitToOptions(false);
        }
        builder.withDescription(description != null ? description : namespace);
        ConfigDescriptionParameter parameter = builder.build();
        return new ConfigDescription(uri, Collections.singletonList(parameter));
    }

    private @Nullable ConfigDescription createParamConfigDescription(MetadataConfigDescriptionProvider provider, String value, @Nullable Locale locale) {
        String namespace = provider.getNamespace();
        URI uri = URI.create("metadata:" + namespace + SEPARATOR + value);
        List<ConfigDescriptionParameter> parameters = provider.getParameters(value, locale);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return new ConfigDescription(uri, parameters);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addMetadataConfigDescriptionProvider(MetadataConfigDescriptionProvider metadataConfigDescriptionProvider) {
        this.providers.add(metadataConfigDescriptionProvider);
    }

    protected void removeMetadataConfigDescriptionProvider(MetadataConfigDescriptionProvider metadataConfigDescriptionProvider) {
        this.providers.remove(metadataConfigDescriptionProvider);
    }
}

