/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.validation;

import java.math.BigDecimal;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.core.internal.validation.ConfigDescriptionParameterValidator;
import org.eclipse.smarthome.config.core.internal.validation.MessageKey;
import org.eclipse.smarthome.config.core.internal.validation.TypeIntrospections;
import org.eclipse.smarthome.config.core.validation.ConfigValidationMessage;

final class MinMaxValidator
implements ConfigDescriptionParameterValidator {
    MinMaxValidator() {
    }

    @Override
    public ConfigValidationMessage validate(ConfigDescriptionParameter parameter, Object value) {
        BigDecimal max;
        BigDecimal min;
        if (value == null || parameter.getType() == ConfigDescriptionParameter.Type.BOOLEAN) {
            return null;
        }
        for (ParameterOption option : parameter.getOptions()) {
            if (!option.getValue().equals(value.toString())) continue;
            return null;
        }
        TypeIntrospections.TypeIntrospection typeIntrospection = TypeIntrospections.get(parameter.getType());
        if (parameter.getMinimum() != null && typeIntrospection.isMinViolated(value, min = parameter.getMinimum())) {
            return MinMaxValidator.createMinMaxViolationMessage(parameter.getName(), typeIntrospection.getMinViolationMessageKey(), min);
        }
        if (parameter.getMaximum() != null && typeIntrospection.isMaxViolated(value, max = parameter.getMaximum())) {
            return MinMaxValidator.createMinMaxViolationMessage(parameter.getName(), typeIntrospection.getMaxViolationMessageKey(), max);
        }
        return null;
    }

    private static ConfigValidationMessage createMinMaxViolationMessage(String parameterName, MessageKey messageKey, BigDecimal minMax) {
        return new ConfigValidationMessage(parameterName, messageKey.defaultMessage, messageKey.key, String.valueOf(minMax));
    }
}

