/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.internal.validation;

import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.internal.validation.ConfigDescriptionParameterValidator;
import org.eclipse.smarthome.config.core.internal.validation.MessageKey;
import org.eclipse.smarthome.config.core.internal.validation.TypeIntrospections;
import org.eclipse.smarthome.config.core.validation.ConfigValidationMessage;

final class TypeValidator
implements ConfigDescriptionParameterValidator {
    TypeValidator() {
    }

    @Override
    public ConfigValidationMessage validate(ConfigDescriptionParameter parameter, Object value) {
        if (value == null) {
            return null;
        }
        TypeIntrospections.TypeIntrospection typeIntrospection = TypeIntrospections.get(parameter.getType());
        if (!typeIntrospection.isAssignable(value)) {
            return TypeValidator.createDataTypeViolationMessage(parameter.getName(), parameter.getType());
        }
        return null;
    }

    private static ConfigValidationMessage createDataTypeViolationMessage(String parameterName, ConfigDescriptionParameter.Type type) {
        return new ConfigValidationMessage(parameterName, MessageKey.DATA_TYPE_VIOLATED.defaultMessage, MessageKey.DATA_TYPE_VIOLATED.key, new Object[]{type});
    }
}

