/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.validation;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.smarthome.config.core.validation.ConfigValidationMessage;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigValidationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(ConfigValidationException.class);
    private final Bundle bundle;
    private final Collection<ConfigValidationMessage> configValidationMessages;
    private final TranslationProvider translationProvider;

    public ConfigValidationException(Bundle bundle, TranslationProvider translationProvider, Collection<ConfigValidationMessage> configValidationMessages) {
        Objects.requireNonNull(bundle, "Bundle must not be null");
        Objects.requireNonNull(configValidationMessages, "Config validation messages must not be null");
        this.bundle = bundle;
        this.translationProvider = translationProvider;
        this.configValidationMessages = configValidationMessages;
    }

    public Map<String, String> getValidationMessages() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (ConfigValidationMessage configValidationMessage : this.configValidationMessages) {
            ret.put(configValidationMessage.parameterName, MessageFormat.format(configValidationMessage.defaultMessage, configValidationMessage.content));
        }
        return Collections.unmodifiableMap(ret);
    }

    public Map<String, String> getValidationMessages(Locale locale) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (ConfigValidationMessage configValidationMessage : this.configValidationMessages) {
            if (this.translationProvider == null) {
                this.logger.warn("TranslationProvider is not available. Will provide default validation message for parameter '{}'.", (Object)configValidationMessage.parameterName);
                ret.put(configValidationMessage.parameterName, MessageFormat.format(configValidationMessage.defaultMessage, configValidationMessage.content));
                continue;
            }
            String text = this.translationProvider.getText(this.bundle, configValidationMessage.messageKey, configValidationMessage.defaultMessage, locale, configValidationMessage.content);
            ret.put(configValidationMessage.parameterName, text);
        }
        return Collections.unmodifiableMap(ret);
    }
}

