/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery.usbserial;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class UsbSerialDeviceInformation {
    private final int vendorId;
    private final int productId;
    private final @Nullable String serialNumber;
    private final @Nullable String manufacturer;
    private final @Nullable String product;
    private final int interfaceNumber;
    private final @Nullable String interfaceDescription;
    private final String serialPort;

    public UsbSerialDeviceInformation(int vendorId, int productId, @Nullable String serialNumber, @Nullable String manufacturer, @Nullable String product, int interfaceNumber, @Nullable String interfaceDescription, String serialPort) {
        this.vendorId = Objects.requireNonNull(vendorId);
        this.productId = Objects.requireNonNull(productId);
        this.serialNumber = serialNumber;
        this.manufacturer = manufacturer;
        this.product = product;
        this.interfaceNumber = interfaceNumber;
        this.interfaceDescription = interfaceDescription;
        this.serialPort = Objects.requireNonNull(serialPort);
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public int getProductId() {
        return this.productId;
    }

    public @Nullable String getSerialNumber() {
        return this.serialNumber;
    }

    public @Nullable String getManufacturer() {
        return this.manufacturer;
    }

    public @Nullable String getProduct() {
        return this.product;
    }

    public int getInterfaceNumber() {
        return this.interfaceNumber;
    }

    public @Nullable String getInterfaceDescription() {
        return this.interfaceDescription;
    }

    public String getSerialPort() {
        return this.serialPort;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.vendorId;
        result = 31 * result + this.productId;
        result = 31 * result + this.interfaceNumber;
        result = 31 * result + this.serialPort.hashCode();
        result = 31 * result + (this.manufacturer == null ? 0 : this.manufacturer.hashCode());
        result = 31 * result + (this.product == null ? 0 : this.product.hashCode());
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + (this.interfaceDescription == null ? 0 : this.interfaceDescription.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsbSerialDeviceInformation other = (UsbSerialDeviceInformation)obj;
        if (this.vendorId != other.vendorId) {
            return false;
        }
        if (this.productId != other.productId) {
            return false;
        }
        if (this.interfaceNumber != other.interfaceNumber) {
            return false;
        }
        if (!this.serialPort.equals(other.serialPort)) {
            return false;
        }
        if (!Objects.equals(this.manufacturer, other.manufacturer)) {
            return false;
        }
        if (!Objects.equals(this.product, other.product)) {
            return false;
        }
        if (!Objects.equals(this.serialNumber, other.serialNumber)) {
            return false;
        }
        return Objects.equals(this.interfaceDescription, other.interfaceDescription);
    }

    public String toString() {
        return String.format("UsbSerialDeviceInformation [vendorId=0x%04X, productId=0x%04X, serialNumber=%s, manufacturer=%s, product=%s, interfaceNumber=0x%02X, interfaceDescription=%s, serialPort=%s]", this.vendorId, this.productId, this.serialNumber, this.manufacturer, this.product, this.interfaceNumber, this.interfaceDescription, this.serialPort);
    }
}

