/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio;

import java.util.Set;

public class AudioFormat {
    public static final AudioFormat MP3 = new AudioFormat("NONE", "MP3", null, null, null, null);
    public static final AudioFormat WAV = new AudioFormat("WAVE", "PCM_SIGNED", null, null, null, null);
    public static final AudioFormat OGG = new AudioFormat("OGG", "VORBIS", null, null, null, null);
    public static final AudioFormat AAC = new AudioFormat("NONE", "AAC", null, null, null, null);
    public static final String CONTAINER_NONE = "NONE";
    public static final String CONTAINER_WAVE = "WAVE";
    public static final String CONTAINER_OGG = "OGG";
    public static final String CODEC_PCM_SIGNED = "PCM_SIGNED";
    public static final String CODEC_PCM_UNSIGNED = "PCM_UNSIGNED";
    public static final String CODEC_PCM_ALAW = "ALAW";
    public static final String CODEC_PCM_ULAW = "ULAW";
    public static final String CODEC_MP3 = "MP3";
    public static final String CODEC_VORBIS = "VORBIS";
    public static final String CODEC_AAC = "AAC";
    private final String codec;
    private final String container;
    private final Boolean bigEndian;
    private final Integer bitDepth;
    private final Integer bitRate;
    private final Long frequency;

    public AudioFormat(String container, String codec, Boolean bigEndian, Integer bitDepth, Integer bitRate, Long frequency) {
        this.container = container;
        this.codec = codec;
        this.bigEndian = bigEndian;
        this.bitDepth = bitDepth;
        this.bitRate = bitRate;
        this.frequency = frequency;
    }

    public String getCodec() {
        return this.codec;
    }

    public String getContainer() {
        return this.container;
    }

    public Boolean isBigEndian() {
        return this.bigEndian;
    }

    public Integer getBitDepth() {
        return this.bitDepth;
    }

    public Integer getBitRate() {
        return this.bitRate;
    }

    public Long getFrequency() {
        return this.frequency;
    }

    public boolean isCompatible(AudioFormat audioFormat) {
        if (audioFormat == null) {
            return false;
        }
        if (this.getContainer() != null && !this.getContainer().equals(audioFormat.getContainer())) {
            return false;
        }
        if (this.getCodec() != null && !this.getCodec().equals(audioFormat.getCodec())) {
            return false;
        }
        if (this.isBigEndian() != null && !this.isBigEndian().equals(audioFormat.isBigEndian())) {
            return false;
        }
        if (this.getBitDepth() != null && !this.getBitDepth().equals(audioFormat.getBitDepth())) {
            return false;
        }
        if (this.getBitRate() != null && !this.getBitRate().equals(audioFormat.getBitRate())) {
            return false;
        }
        return this.getFrequency() == null || this.getFrequency().equals(audioFormat.getFrequency());
    }

    public static AudioFormat getBestMatch(Set<AudioFormat> inputs, Set<AudioFormat> outputs) {
        AudioFormat preferredFormat = AudioFormat.getPreferredFormat(inputs);
        if (preferredFormat != null) {
            for (AudioFormat output : outputs) {
                if (output.isCompatible(preferredFormat)) {
                    return preferredFormat;
                }
                for (AudioFormat input : inputs) {
                    if (!output.isCompatible(input)) continue;
                    return input;
                }
            }
        }
        return null;
    }

    public static AudioFormat getPreferredFormat(Set<AudioFormat> audioFormats) {
        for (AudioFormat currentAudioFormat : audioFormats) {
            if (currentAudioFormat.getCodec() == null || currentAudioFormat.getContainer() == null || currentAudioFormat.isBigEndian() == null || currentAudioFormat.getBitDepth() == null || currentAudioFormat.getBitRate() == null || currentAudioFormat.getFrequency() == null || !currentAudioFormat.getContainer().equals(CONTAINER_WAVE)) continue;
            return currentAudioFormat;
        }
        for (AudioFormat currentAudioFormat : audioFormats) {
            AudioFormat format = currentAudioFormat;
            if (format.getCodec() == null || format.getContainer() == null || !format.getContainer().equals(CONTAINER_WAVE)) continue;
            if (format.isBigEndian() == null) {
                format = new AudioFormat(format.getContainer(), format.getCodec(), new Boolean(true), format.getBitDepth(), format.getBitRate(), format.getFrequency());
            }
            if (format.getBitDepth() == null || format.getBitRate() == null || format.getFrequency() == null) {
                int defaultBitDepth = 16;
                long defaultFrequency = 16384L;
                Integer bitRate = format.getBitRate();
                Long frequency = format.getFrequency();
                Integer bitDepth = format.getBitDepth();
                if (bitRate == null) {
                    if (bitDepth == null) {
                        bitDepth = new Integer(defaultBitDepth);
                    }
                    if (frequency == null) {
                        frequency = new Long(defaultFrequency);
                    }
                    bitRate = new Integer(bitDepth * frequency.intValue());
                } else if (bitDepth == null) {
                    if (frequency == null) {
                        frequency = new Long(defaultFrequency);
                    }
                    bitDepth = new Integer(bitRate / frequency.intValue());
                } else if (frequency == null) {
                    frequency = new Long(bitRate.longValue() / bitDepth.longValue());
                }
                format = new AudioFormat(format.getContainer(), format.getCodec(), format.isBigEndian(), bitDepth, bitRate, frequency);
            }
            return format;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AudioFormat) {
            AudioFormat format = (AudioFormat)obj;
            if (this.getCodec() == null ? format.getCodec() != null : !this.getCodec().equals(format.getCodec())) {
                return false;
            }
            if (this.getContainer() == null ? format.getContainer() != null : !this.getContainer().equals(format.getContainer())) {
                return false;
            }
            if (this.isBigEndian() == null ? format.isBigEndian() != null : !this.isBigEndian().equals(format.isBigEndian())) {
                return false;
            }
            if (this.getBitDepth() == null ? format.getBitDepth() != null : !this.getBitDepth().equals(format.getBitDepth())) {
                return false;
            }
            if (this.getBitRate() == null ? format.getBitRate() != null : !this.getBitRate().equals(format.getBitRate())) {
                return false;
            }
            return !(this.getFrequency() == null ? format.getFrequency() != null : !this.getFrequency().equals(format.getFrequency()));
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bigEndian == null ? 0 : this.bigEndian.hashCode());
        result = 31 * result + (this.bitDepth == null ? 0 : this.bitDepth.hashCode());
        result = 31 * result + (this.bitRate == null ? 0 : this.bitRate.hashCode());
        result = 31 * result + (this.codec == null ? 0 : this.codec.hashCode());
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        return result;
    }

    public String toString() {
        return "AudioFormat [" + (this.codec != null ? "codec=" + this.codec + ", " : "") + (this.container != null ? "container=" + this.container + ", " : "") + (this.bigEndian != null ? "bigEndian=" + this.bigEndian + ", " : "") + (this.bitDepth != null ? "bitDepth=" + this.bitDepth + ", " : "") + (this.bitRate != null ? "bitRate=" + this.bitRate + ", " : "") + (this.frequency != null ? "frequency=" + this.frequency : "") + "]";
    }
}

