/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.persistence.internal;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.config.core.ConfigOptionProvider;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.PersistenceServiceRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, configurationPid="org.eclipse.smarthome.persistence", property={"service.pid:String=org.eclipse.smarthome.persistence", "service.config.description.uri:String=system:persistence", "service.config.label:String=Persistence", "service.config.category:String=system"})
public class PersistenceServiceRegistryImpl
implements ConfigOptionProvider,
PersistenceServiceRegistry {
    private final Map<String, PersistenceService> services = new HashMap<String, PersistenceService>();
    private String defaultServiceId = null;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addPersistenceService(PersistenceService service) {
        this.services.put(service.getId(), service);
    }

    public void removePersistenceService(PersistenceService service) {
        this.services.remove(service.getId());
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        if (config != null) {
            this.defaultServiceId = (String)config.get("default");
        }
    }

    @Override
    public PersistenceService getDefault() {
        return this.get(this.getDefaultId());
    }

    @Override
    public PersistenceService get(String serviceId) {
        if (serviceId != null) {
            return this.services.get(serviceId);
        }
        return null;
    }

    @Override
    public String getDefaultId() {
        if (this.defaultServiceId != null) {
            return this.defaultServiceId;
        }
        if (this.services.size() == 1) {
            return this.services.keySet().iterator().next();
        }
        return null;
    }

    @Override
    public Set<PersistenceService> getAll() {
        return new HashSet<PersistenceService>(this.services.values());
    }

    public Collection<ParameterOption> getParameterOptions(URI uri, String param, Locale locale) {
        if (uri.toString().equals("system:persistence") && param.equals("default")) {
            HashSet<ParameterOption> options = new HashSet<ParameterOption>();
            for (PersistenceService service : this.getAll()) {
                options.add(new ParameterOption(service.getId(), service.getLabel(locale)));
            }
            return options;
        }
        return null;
    }
}

