/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.xml.util.GenericUnmarshaller;
import org.eclipse.smarthome.config.xml.util.NodeIterator;
import org.eclipse.smarthome.config.xml.util.NodeList;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.types.EventDescription;
import org.eclipse.smarthome.core.types.EventOption;

public class EventDescriptionConverter
extends GenericUnmarshaller<EventDescription> {
    public EventDescriptionConverter() {
        super(EventDescription.class);
    }

    private List<EventOption> toListOfEventOptions(NodeList nodeList) throws ConversionException {
        if ("options".equals(nodeList.getNodeName())) {
            ArrayList<EventOption> eventOptions = new ArrayList<EventOption>();
            for (Object nodeObject : nodeList.getList()) {
                eventOptions.add(this.toEventOption((NodeValue)nodeObject));
            }
            return eventOptions;
        }
        throw new ConversionException("Unknown type '" + nodeList.getNodeName() + "'!");
    }

    private EventOption toEventOption(NodeValue nodeValue) throws ConversionException {
        if ("option".equals(nodeValue.getNodeName())) {
            Map attributes = nodeValue.getAttributes();
            if (attributes == null || !attributes.containsKey("value")) {
                throw new ConversionException("The node 'option' requires the attribute 'value'!");
            }
            String value = (String)attributes.get("value");
            String label = (String)nodeValue.getValue();
            return new EventOption(value, label);
        }
        throw new ConversionException("Unknown type in the list of 'options'!");
    }

    public final Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        List<EventOption> eventOptions = null;
        NodeList nodes = (NodeList)context.convertAnother((Object)context, NodeList.class);
        NodeIterator nodeIterator = new NodeIterator(nodes.getList());
        NodeList optionNodes = (NodeList)nodeIterator.next();
        if (optionNodes != null) {
            eventOptions = this.toListOfEventOptions(optionNodes);
        }
        nodeIterator.assertEndOfType();
        EventDescription eventDescription = new EventDescription(eventOptions);
        return eventDescription;
    }
}

